<?php

namespace apexl\Io\modules\queueDisplay\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\System;
use apexl\Io\modules\display\components\ContentTitle;
use apexl\Io\modules\display\components\RowWrapper;
use apexl\Io\modules\display\services\Render;
use apexl\Io\modules\queue\dto\queueSettings\queueSettingsStatsDto;
use apexl\Io\modules\queue\entities\queueItem;
use apexl\Io\modules\queueDisplay\components\statsComponent;
use apexl\Io\modules\queueDisplay\pages\noUiNoLogo;
use apexl\Io\services\Output;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

class statsDisplayController extends Controller
{
    public function stats(ServerRequestInterface $request, ResponseInterface $response): ResponseInterface
    {
        Render::setActive(noUiNoLogo::class);

        Output::addResponse($request, Render::build([
            System::getRegisteredService(StatsComponent::class)
                ->addClass('stats__lead'),
        ]));

        return System::asJson($response);
    }

}
