<?php declare(strict_types=1);

namespace apexl\Io\modules\queueDisplay\forms;

use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\inputField;
use apexl\Io\modules\formbuilder\includes\markupField;
use apexl\Io\modules\queue\dto\queueSettings\queueSettingsJoinDto;
use apexl\Io\modules\queue\enums\CommunicationOptions;
use apexl\Io\modules\queueDisplay\interfaces\formInterface;

class joinQueue implements formInterface
{
    public const FIELD__PHONE = 'phone';
    public const FIELD__EMAIL = 'email';

    private queueSettingsJoinDto $settings;

    public function __construct()
    {
        $this->settings = queueSettingsJoinDto::fromDb(true);
    }

    public function form(array $args = []): formEntity
    {

        $action = $args['action'];

        $form = new formEntity();
        $form->setId('join-queue');
        $form->setMethod('post');
        $form->setSubmitText('Join queue');
        $form->setActionUrl($action);

        $form->addField((new markupField(
            'markup-join',
            '<h3 class="text-left">Join the queue</h3>',
        )));

        if ($this->collectPhone()) {
            $form->addField((new markupField(
                'markup-phone',
                '<p class="text-left">Enter your phone number to receive an SMS message when it is your turn.</p>',
            )));

            $form->addField(
                (new inputField(self::FIELD__PHONE, 'tel'))
                    ->setPlaceholder('Phone number')
                    ->isRequired($this->phoneIsRequired())
            );
        }

        if ($this->collectEmail()) {
            $form->addField((new markupField(
                'markup-email',
                '<p class="text-left">Enter your email address to receive an email when it is your turn.</p>',
            )));

            $form->addField(
                (new inputField(self::FIELD__EMAIL, 'email'))
                    ->setPlaceholder('Email address')
                    ->isRequired($this->emailIsRequired())
            );
        }

        return $form;
    }

    private function collectPhone(): bool
    {
        return $this->collectCommunication(queueSettings::FIELD__COLLECT_PHONE);
    }

    private function collectEmail(): bool
    {
        return $this->collectCommunication(queueSettings::FIELD__COLLECT_EMAIL);
    }

    private function collectCommunication(string $field): bool
    {
        if (!CommunicationOptions::isValid($this->settings->{$field})) {
            return false;
        }

        return !CommunicationOptions::UNUSED()
            ->equals(CommunicationOptions::from($this->settings->{$field}));

    }

    private function phoneIsRequired(): bool
    {
        return $this->communicationIsRequired(queueSettings::FIELD__COLLECT_PHONE);
    }

    private function emailIsRequired(): bool
    {
        return $this->communicationIsRequired(queueSettings::FIELD__COLLECT_EMAIL);
    }

    private function communicationIsRequired(string $field): bool
    {
        if (!CommunicationOptions::isValid($this->settings->{$field})) {
            return false;
        }

        return CommunicationOptions::REQUIRED()
            ->equals(CommunicationOptions::from($this->settings->{$field}));
    }
}
