<?php declare(strict_types=1);

namespace apexl\Io\modules\queueDisplay\forms;

use apexl\Io\includes\Routes;
use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\inputField;
use apexl\Io\modules\queueDisplay\interfaces\formInterface;

abstract class queueSettings implements formInterface
{

    public const FIELD__ACTIVE_TITLE = 'active_title';
    public const FIELD__UPCOMING_TITLE = 'upcoming_title';
    public const FIELD__JOINED_TEMPLATE = 'joined_template';
    public const FIELD__ADDITION_TOTAL = 'addition_total';
    public const FIELD__DISPLAY_UPCOMING = 'display_upcoming';
    public const FIELD__WAITING_PERIOD = 'waiting_period';
    public const FIELD__STATS_LEAD = 'stats_lead';
    public const FIELD__STATS_VIDEO = 'stats_video';
    public const FIELD__STATS_CONTENT = 'stats_content';
    public const FIELD__SETTINGS_PAGE = 'page';
    public const FIELD__COLLECT_PHONE = 'collect_phone';
    public const FIELD__COLLECT_EMAIL = 'collect_email';
    public const FIELD__ACTIVE_COUNT = 'active_count';
    public const FIELD__NOTIFY_SMS = 'notify_sms';
    public const FIELD__NOTIFY_EMAIL = 'notify_email';
    public const FIELD__SMS_CONTENT = 'sms_content';
    public const FIELD__EMAIL_CONTENT = 'email_content';
    public const FIELD__EMAIL_SUBJECT = 'email_subject';

    protected formEntity $form;

    protected function id(): string
    {
        return sprintf('queue-settings--%s', static::PAGE);
    }

    protected abstract function settings(): void;

    public function __construct()
    {
        $this->form = $this->initForm();
        $this->settings();
    }

    protected function initForm(array $args = []): formEntity
    {
        $form = new formEntity();
        $form->setId($this->id());
        $form->setMethod('post');
        $form->setSubmitText('Save settings');
        $form->setActionUrl(Routes::getRoutePattern('queue.settings.update'));

        $form->addField(
            (new inputField(queueSettings::FIELD__SETTINGS_PAGE, 'hidden'))
            ->setValue($this->page())
        );

        return $form;
    }

    private function page()
    {
        return static::PAGE;
    }
}
