<?php declare(strict_types=1);

namespace apexl\Io\modules\queueDisplay\forms\queueSettings;

use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\checkboxField;
use apexl\Io\modules\formbuilder\includes\inputField;
use apexl\Io\modules\formbuilder\includes\radioGroupField;
use apexl\Io\modules\formbuilder\includes\textareaField;
use apexl\Io\modules\queue\dto\queueSettings\queueSettingsJoinDto;
use apexl\Io\modules\queue\enums\CommunicationOptions;
use apexl\Io\modules\queueDisplay\forms\queueSettings;

class joinPageSettings extends queueSettings
{
    public const PAGE = 'join';

    protected queueSettingsJoinDto $settings;

    protected function settings(): void
    {
        $this->settings = queueSettingsJoinDto::fromDb();
    }

    public function form(array $args = []): formEntity
    {
        $this->form->addField(
            (new radioGroupField(queueSettings::FIELD__COLLECT_PHONE, $this->communicationOptions()))
                ->setLabel('Collect phone number')
                ->setValue($this->settings->{queueSettings::FIELD__COLLECT_PHONE} ?? queueSettingsJoinDto::DEFAULT__PHONE)
        );

        $this->form->addField(
            (new radioGroupField(queueSettings::FIELD__COLLECT_EMAIL, $this->communicationOptions()))
                ->setLabel('Collect email')
                ->setValue($this->settings->{queueSettings::FIELD__COLLECT_EMAIL} ?? queueSettingsJoinDto::DEFAULT__EMAIL)
        );

        $this->form->addField(
            (new checkboxField(queueSettings::FIELD__NOTIFY_SMS))
                ->setLabel('Send notification SMS')
                ->setValue($this->settings->{queueSettings::FIELD__NOTIFY_SMS} ?? queueSettingsJoinDto::DEFAULT__NOTIFY_SMS)
        );

        $this->form->addField(
            (new inputField(queueSettings::FIELD__SMS_CONTENT))
                ->setLabel('SMS Content')
                ->setValue($this->settings->{queueSettings::FIELD__SMS_CONTENT} ?? '')
                ->setPlaceholder(queueSettingsJoinDto::DEFAULT__SMS_CONTENT)
                ->setHelp('[POSITION] will be substituted for the customer\'s position.')
        );

        $this->form->addField(
            (new checkboxField(queueSettings::FIELD__NOTIFY_EMAIL))
                ->setLabel('Send notification Email')
                ->setValue($this->settings->{queueSettings::FIELD__NOTIFY_EMAIL} ?? queueSettingsJoinDto::DEFAULT__NOTIFY_EMAIL)
        );

        $this->form->addField(
            (new inputField(queueSettings::FIELD__EMAIL_SUBJECT))
                ->setLabel('Email Subject')
                ->setValue($this->settings->{queueSettings::FIELD__EMAIL_SUBJECT} ?? '')
                ->setPlaceholder(queueSettingsJoinDto::DEFAULT__EMAIL_SUBJECT)
                ->setHelp('[POSITION] will be substituted for the customer\'s position.')
        );
        $this->form->addField(
            (new textareaField(queueSettings::FIELD__EMAIL_CONTENT))
                ->setLabel('Email Content')
                ->setValue($this->settings->{queueSettings::FIELD__EMAIL_CONTENT} ?? '')
                ->setPlaceholder(queueSettingsJoinDto::DEFAULT__EMAIL_CONTENT)
                ->setHelp('[POSITION] will be substituted for the customer\'s position.')
        );


        return $this->form;
    }

    private function communicationOptions(): array
    {
        return array_combine(
            array_values(CommunicationOptions::toArray()),
            array_map(fn($value) => ucfirst($value),CommunicationOptions::toArray()),
        );
    }
}
