<?php declare(strict_types=1);

namespace apexl\Io\modules\queueDisplay\forms\queueSettings;

use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\inputField;
use apexl\Io\modules\formbuilder\includes\numberField;
use apexl\Io\modules\queue\dto\queueSettings\queueSettingsQueueDto;
use apexl\Io\modules\queueDisplay\forms\queueSettings;

class queuePageSettings extends queueSettings
{
    public const PAGE = 'queue';

    protected queueSettingsQueueDto $settings;

    protected function settings(): void
    {
        $this->settings = queueSettingsQueueDto::fromDb();
    }

    public function form(array $args = []): formEntity
    {
        $this->form->addField(
            (new inputField(queueSettings::FIELD__ACTIVE_TITLE))
                ->setLabel('Active Title')
                ->setValue($this->settings->{queueSettings::FIELD__ACTIVE_TITLE})
                ->setPlaceholder(queueSettingsQueueDto::DEFAULT__ACTIVE_TITLE)
        );

        $this->form->addField(
            (new inputField(queueSettings::FIELD__UPCOMING_TITLE))
                ->setLabel('Upcoming Title')
                ->setValue($this->settings->{queueSettings::FIELD__UPCOMING_TITLE})
                ->setPlaceholder(queueSettingsQueueDto::DEFAULT__UPCOMING_TITLE)
        );

        $this->form->addField(
            (new inputField(queueSettings::FIELD__JOINED_TEMPLATE))
                ->setLabel('Joined text')
                ->setValue($this->settings->{queueSettings::FIELD__JOINED_TEMPLATE})
                ->setPlaceholder(queueSettingsQueueDto::DEFAULT__JOINED_TEMPLATE)
                ->setHelp(
                    'This will be displayed after someone has joined the queue. ' .
                    '\'[POSITION]\' will be replaced with their position in the queue.'
                )
        );

        $this->form->addField(
            (new numberField(queueSettings::FIELD__ACTIVE_COUNT))
                ->setLabel('Active count')
                ->setValue($this->settings->{queueSettings::FIELD__ACTIVE_COUNT})
                ->setPlaceholder(queueSettingsQueueDto::DEFAULT__ACTIVE_COUNT)
                ->setHelp('How many customers can be called up at once')
        );

        $this->form->addField(
            (new numberField(queueSettings::FIELD__DISPLAY_UPCOMING))
                ->setLabel('Upcoming count')
                ->setValue($this->settings->{queueSettings::FIELD__DISPLAY_UPCOMING})
                ->setPlaceholder(queueSettingsQueueDto::DEFAULT__DISPLAY_UPCOMING)
                ->setHelp('Limit the display of upcoming queue items.  Enter -1 for no limit.')
        );

        $this->form->addField(
            (new numberField(queueSettings::FIELD__WAITING_PERIOD))
                ->setLabel('Arbitrary waiting period')
                ->setValue($this->settings->{queueSettings::FIELD__WAITING_PERIOD})
                ->setPlaceholder(queueSettingsQueueDto::DEFAULT__WAITING_PERIOD)
                ->setHelp(
                    'Number of minutes to always wait before a visitor is called up, ' .
                    'if there is no-one in the queue.'
                )
        );

        return $this->form;
    }
}
