<?php declare(strict_types=1);

namespace apexl\Io\modules\queueDisplay\forms\queueSettings;

use apexl\Io\includes\Routes;
use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\dropzoneField;
use apexl\Io\modules\formbuilder\includes\numberField;
use apexl\Io\modules\formbuilder\includes\textareaField;
use apexl\Io\modules\queue\dto\queueSettings\queueSettingsStatsDto;
use apexl\Io\modules\queueDisplay\forms\queueSettings;

class statsPageSettings extends queueSettings
{
    public const PAGE = 'stats';

    private queueSettingsStatsDto $settings;

    protected function settings(): void
    {
        $this->settings = queueSettingsStatsDto::fromDb();
    }

    public function form(array $args = []): formEntity
    {
        $this->form->addField(
            (new textareaField(queueSettings::FIELD__STATS_LEAD))
                ->setLabel('[COUNT] will be replaced by the (amended) count of customers served')
                ->setValue($this->settings->{queueSettings::FIELD__STATS_LEAD})
                ->setPlaceholder(queueSettingsStatsDto::DEFAULT__STATS_LEAD)
                ->setHelp('This will be added to the total number people served when it is displayed.')
        );

        $this->form->addField(
            (new dropzoneField(queueSettings::FIELD__STATS_VIDEO))->setFileSavePath(
                Routes::getRoutePattern('queue.settings.upload.video'),
            )->setValue($this->settings->stats_video)
        );

        $this->form->addField(
            (new numberField(queueSettings::FIELD__ADDITION_TOTAL))
                ->setLabel('Add to total')
                ->setValue($this->settings->{queueSettings::FIELD__ADDITION_TOTAL})
                ->setPlaceholder(queueSettingsStatsDto::DEFAULT__ADDITION_TOTAL)
                ->setHelp('This will be added to the total number people served when it is displayed.')
        );

        return $this->form;
    }
}
