<?php declare(strict_types=1);

namespace apexl\Io\modules\queueDisplay;

use apexl\Io\includes\Entity;
use apexl\Io\includes\Hook;
use apexl\Io\modules\basicDisplay\basicDisplayModule;
use apexl\Io\modules\display\services\Render;
use apexl\Io\modules\menu\services\Menu;
use apexl\Io\modules\queue\controllers\clearQueueController;
use apexl\Io\modules\queue\entities\queueItem;
use apexl\Io\modules\queue\listeners\postAuthListener;
use apexl\Io\modules\queue\queueModule;
use apexl\Io\modules\queueDisplay\controllers\displayQueueDisplayController;
use apexl\Io\modules\queueDisplay\controllers\joinQueueDisplayController;
use apexl\Io\modules\queueDisplay\controllers\queueSettingsDisplayController;
use apexl\Io\modules\queueDisplay\controllers\statsDisplayController;
use apexl\Io\modules\queueDisplay\pages\noUiNoLogo;

class queueDisplayModule extends basicDisplayModule {

    public function __construct()
    {
        parent::__construct(new queueItem());
        $this->registerCallbacks();
    }

    public function registerCallbacks(){
        postAuthListener::register();
    }

    public function routes(): void
    {
        parent::routes();

        $this->route->get(
            'queue.display.join',
            '/queue/join',
            [joinQueueDisplayController::class, 'join']
        );

        $this->route->get(
            'queue.display.join.form',
            '/queue/join/form',
            [joinQueueDisplayController::class, 'form']
        );

        $this->route->get(
            'queue.display.joined',
            '/queue/joined/{uuid}',
            [joinQueueDisplayController::class, 'joined']
        );

        $this->route->get(
            'queue.display.display',
            '/queue',
            [displayQueueDisplayController::class, 'display']
        );

        $this->route->get(
            'queue.display.stats',
            '/queue/stats',
            [statsDisplayController::class, 'stats']
        );

        $this->addProtectedAdminRootRoute(
            'get',
            'queue.settings.queue',
            'queue/settings/queue',
            [queueSettingsDisplayController::class, 'queue'],
//            queueModule::PERMISSION__MANAGE_QUEUE,
        );

        $this->addProtectedAdminRootRoute(
            'get',
            'queue.settings.join',
            'queue/settings/join',
            [queueSettingsDisplayController::class, 'join'],
            queueModule::PERMISSION__MANAGE_QUEUE,
        );

        $this->addProtectedAdminRootRoute(
            'get',
            'queue.settings.stats',
            'queue/settings/stats',
            [queueSettingsDisplayController::class, 'stats'],
            queueModule::PERMISSION__MANAGE_QUEUE,
        );

        $this->addProtectedAdminRootRoute(
            'get',
            'queue.settings.form',
            'queue/settings/{form}/form',
            [queueSettingsDisplayController::class, 'form'],
            queueModule::PERMISSION__MANAGE_QUEUE,
        );

        $this->addProtectedAdminRootRoute(
            'get',
            'queue.clear',
            'queue/clear',
            [clearQueueController::class, 'clear'],
            queueModule::PERMISSION__MANAGE_QUEUE,
        );
    }

    protected function entityRoutesArray(Entity $entity): array
    {
        if ($entity instanceof queueItem) {
            return [
                'all' => $this->entityRoute($entity, 'all', 'View'),
                'post' => $this->entityRoute($entity, 'create', 'Create'),
                'delete' => $this->entityRoute($entity, 'delete', 'Delete'),
            ];
        }

        return parent::entityRoutesArray($entity);
    }

    public function registerMenuItems(): void
    {
        parent::registerMenuItems();

        Menu::addToMenu(
            'queue.settings',
            [
                'title' => 'Queue',
                'icon' => 'timeline',
                'weight' => 0,
            ],
            'administration'
        );

        Menu::addToMenu(
            'queue.settings.queue',
            [
                'title' => 'Queue Display',
                'weight' => 0,
                'parent' => 'queue.settings',
                'icon' => 'timeline'
            ],
            'administration'
        );

        Menu::addToMenu(
            'queue.settings.join',
            [
                'title' => 'Join page',
                'weight' => 0,
                'parent' => 'queue.settings',
                'icon' => 'right-to-bracket'
            ],
            'administration'
        );

        Menu::addToMenu(
            'queue.settings.stats',
            [
                'title' => 'Stats Display',
                'weight' => 0,
                'parent' => 'queue.settings',
                'icon' => 'chart-pie'
            ],
            'administration'
        );

        Menu::addToMenu(
            'queue.clear',
            [
                'title' => 'Clear queue',
                'weight' => 0,
                'parent' => 'queue.settings',
                'icon' => 'trash'
            ],
            'administration'
        );
    }
}
