<?php

namespace apexl\Io\modules\skyDisplay\callbacks;

use apexl\Io\modules\component\entities\componentEntity;
use apexl\Io\modules\menu\entities\menuEntity;
use apexl\Io\modules\menu\services\Menu;
use apexl\Io\modules\user\services\currentUser;

class generalPageCallbacks {
    /**
     * CALLBACK
     * @see io-display module /pages/genericPage.php wrapper() method.
     * @param $component
     * @param $componentName
     * @return componentEntity | boolean
     */
    public static function genericWrapperAlter($component, $componentName){
        switch($componentName){
            case 'ImageTile':
                $component->classes = 'col-md-2 col-sm-4 col-xs-8';
                break;
            case 'TheTopMenuBar':
                $menu = Menu::getInstance();
                $currentUser = currentUser::getCurrentUser();
                $horizontalMenu = new componentEntity();
                $horizontalMenu->name = 'HorizontalMenu';
                $horizontalMenu->id = 'TopBarMainMenu';
                $horizontalMenu->classes = 'col-lg-8 col-sm-6 col-xs-2';
                $horizontalMenu->addProperty('menuItems', $menu->getAllItemsAsMenu($currentUser));

                $component->addComponent($horizontalMenu);

                $menuEntity = new menuEntity();
                $menuEntity->loadByName("Account Menu");

                $userMenu = new componentEntity();
                $userMenu->name = 'SimpleDropdownMenu';
                $userMenu->id = 'TopBarUserMenu';
                $userMenu->classes = 'col-sm-2';
                $userMenu->addProperty('menuItems', $menuEntity->getAllItemsAsMenu($currentUser));
                $userMenu->addProperty('menuTitle', $currentUser->getNiceName());
                $userMenu->addProperty('menuIcon', 'user-circle');

                $component->addComponent($userMenu);
                break;
            case 'TheLeftSidebar':
                //remove the sidebar
                $component = FALSE;
                break;
            case 'ContentPreComponents':
                $component->classes = 'col-lg-12';
                break;
            case 'TitleTile':
                break;
        }
        return $component;
    }
}