<?php
namespace apexl\Io\modules\subscriptionDisplay\components;

use apexl\Io\includes\Hook;
use apexl\Io\modules\display\components\BasicLink;
use apexl\Io\modules\display\components\DisplayTable;
use apexl\Io\modules\display\components\genericComponents;
use apexl\Io\modules\product\entities\productEntity;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\services\currentUser;

class viewTiles {

    public static function subscriptionViewTile($subscription){
        if($subscription) {
            $currentUser = currentUser::getCurrentUser();

            $user = new userEntity();
            $user->load($subscription->user_id);
            $product = new productEntity();
            $product->load($subscription->product_id);

            $userInfo = new DisplayTable();
            $userInfo->addData('Email', $user->email);

            $subscriptionInfo = new DisplayTable();
            $subscriptionInfo->addData('Product', $product->product_name);
            $subscriptionInfo->addData('Quantity', $subscription->product_quantity);
            $subscriptionInfo->addData('Monthly Fee', '£'.number_format($product->price, 2) . ' (£'.number_format($subscription->product_quantity*$product->price, 2).' total)  Exc. VAT');
            $subscriptionInfo->addData('Nominal Code', $product->invoice_nominal_code);
            $subscriptionInfo->addData('Enabled?', ($subscription->enabled == 1 ? 'Yes' : 'No'));

            $startDate = \DateTime::createFromFormat('Y-m-d', $subscription->date_starts);
            $subscriptionInfo->addData('Started', $startDate->format('d M Y'));

            $lastBillingDate = \DateTime::createFromFormat('Y-m-d', $subscription->last_billing_date);
            if ($lastBillingDate instanceof \DateTime){
                $subscriptionInfo->addData('Last Billed on', $lastBillingDate->format('d M Y'));
            } else {
                $subscriptionInfo->addData('Last Billed on', 'N/A');
            }

            $nextBillingDate = \DateTime::createFromFormat('Y-m-d', $subscription->next_billing_date);
            $subscriptionInfo->addData('Next Billed on', $nextBillingDate->format('d M Y'));

            list($userInfo, $subscriptionInfo) = $entityData = Hook::processHook('modify_subscription_display_fields', $subscription, $userInfo, $subscriptionInfo);

            $components = [];
            $components[] = genericComponents::ContentTitle("User");
            $components[] = $userInfo;
            $components[] = genericComponents::ContentTitle("Subscription");
            $components[] = $subscriptionInfo;

            return genericComponents::dashboardBlockWrapper($components);
        } else {
            return genericComponents::dashboardBlockWrapper([]);
        }
    }
}