<?php
namespace apexl\Io\modules\subscriptionDisplay\components;

use apexl\Config\Singleton;
use apexl\Io\includes\Hook;
use apexl\Io\includes\Routes;
use apexl\Io\includes\System;
use apexl\Io\modules\display\components\BasicLink;
use apexl\Io\modules\display\components\CardEntityFilteredDisplayTable;
use apexl\Io\modules\display\components\ColWrapper;
use apexl\Io\modules\display\components\ContentTitle;
use apexl\Io\modules\display\components\DisplayTable;
use apexl\Io\modules\display\components\EntityFilteredDisplayTable;
use apexl\Io\modules\display\components\genericComponents;
use apexl\Io\modules\display\components\Modal;
use apexl\Io\modules\display\components\SimpleButton;
use apexl\Io\modules\product\entities\productEntity;
use apexl\Io\modules\subscription\entities\subscriptionEntity;
use apexl\Io\modules\subscription\services\subscriptionService;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\services\currentUser;
use apexl\Io\modules\userDisplay\components\dashboardTiles;
use apexl\Io\services\Logger;
use app\module\billing\entities\billingSimSettingsEntity;

class viewTiles {

    public static function getSubscriptionStatusLozenge($subscriptionEntity, $clickable=false)
    {

        if ($subscriptionEntity->enabled == '1' && $subscriptionEntity->suspended == '0' && $subscriptionEntity->cancellation_date >= date('Y-m-d')) {
            $date = \DateTime::createFromFormat('Y-m-d', $subscriptionEntity->cancellation_date);
            $btnContent = (System::getVariable('io_subscription_pending_cancellation_not_suspended_text') ?? 'Active, Pending Cancellation') . ' '.$date->format('jS M Y');
            $btnClass = 'bg-warning';
        } elseif ($subscriptionEntity->enabled == '1' && $subscriptionEntity->suspended == '1' && $subscriptionEntity->cancellation_date >= date('Y-m-d')) {
            $date = \DateTime::createFromFormat('Y-m-d', $subscriptionEntity->cancellation_date);
            $btnContent = (System::getVariable('io_subscription_pending_cancellation_suspended_text') ?? 'Active, Pending Cancellation') . ' '.$date->format('jS M Y');
            $btnClass = 'bg-warning';
        } elseif ($subscriptionEntity->enabled == '1' && $subscriptionEntity->suspended == '0') {
            $btnContent = System::getVariable('io_subscription_active_not_suspended_text') ?? 'Active';
            $btnClass = 'bg-success text-white';
        } elseif ($subscriptionEntity->enabled == '0' && $subscriptionEntity->suspended == '1') {
            $btnContent = System::getVariable('io_subscription_inactive_suspended_text') ?? 'Inactive';'Inactive, SIMs suspended';
            $btnClass = 'bg-danger text-white';
        } elseif ($subscriptionEntity->enabled == '1' && $subscriptionEntity->suspended == '1') {
            $btnContent = System::getVariable('io_subscription_active_suspended_text') ?? 'Active';'Active, SIMs suspended';
            $btnClass = 'bg-warning';
        } elseif ($subscriptionEntity->enabled == '0' && $subscriptionEntity->suspended == '0') {
            $btnContent = System::getVariable('io_subscription_inactive_not_suspended_text') ?? 'Inactive';'Inactive, SIMs Active';
            $btnClass = 'bg-danger text-white';
        }
        $btnContent = "Subscription $btnContent";

        if ($clickable) {
            $button = (new Modal())
                ->setContentSrc('subscriptionDisplay.suspend', ['id' => $subscriptionEntity->id])
                ->setTitle('Subscription Status');
            $button->setButtonContent($btnContent)->addClass($btnClass . ' btn');
        } else {
            $button = (new SimpleButton());
            $button->addText($btnContent)->addClass($btnClass);
        }

        return $button;
    }

    public static function getSubscriptionStatusText($subscriptionEntity)
    {
        if ($subscriptionEntity->enabled == '1' && $subscriptionEntity->suspended == '0' && $subscriptionEntity->cancellation_date >= date('Y-m-d')) {
            return System::getVariable('io_subscription_pending_cancellation_not_suspended_text') ?? 'Active, Pending Cancellation';
        } elseif ($subscriptionEntity->enabled == '1' && $subscriptionEntity->suspended == '1' && $subscriptionEntity->cancellation_date >= date('Y-m-d')) {
            return System::getVariable('io_subscription_pending_cancellation_suspended_text') ?? 'Active, Pending Cancellation';
        } elseif ($subscriptionEntity->enabled == '1' && $subscriptionEntity->suspended == '0') {
            return System::getVariable('io_subscription_active_not_suspended_text') ?? 'Active';
        } elseif ($subscriptionEntity->enabled == '0' && $subscriptionEntity->suspended == '1') {
            return System::getVariable('io_subscription_inactive_suspended_text') ?? 'Inactive';'Inactive, SIMs suspended';
        } elseif ($subscriptionEntity->enabled == '1' && $subscriptionEntity->suspended == '1') {
            return System::getVariable('io_subscription_active_suspended_text') ?? 'Active';'Active, SIMs suspended';
        } elseif ($subscriptionEntity->enabled == '0' && $subscriptionEntity->suspended == '0') {
            return System::getVariable('io_subscription_inactive_not_suspended_text') ?? 'Inactive';'Inactive, SIMs Active';
        }

        return 'Unknown';
    }

    public static function subscriptionViewTile($subscription){
        if($subscription) {
            $currentUser = currentUser::getCurrentUser();

            $user = new userEntity();
            $user->load($subscription->user_id);
            $product = new productEntity();
            $product->load($subscription->product_id);

            $userInfo = new DisplayTable();
            $userInfo->addData('Email', $user->email);

            $subscriptionInfo = new DisplayTable();
            $subscriptionInfo->addData('Product', $product->product_name);
            $subscriptionInfo->addData('Quantity', $subscription->product_quantity);
            if (trim($subscription->price_override) != "") {
                $monthlyFee = trim($subscription->price_override);
                $monthlyFee = (float)$monthlyFee;
                $subscriptionInfo->addData('£'.number_format($monthlyFee, 2).' total  Exc. VAT');
            } else {
                $subscriptionInfo->addData('Monthly Fee', '£'.number_format($product->price, 2) . ' (£'.number_format($subscription->product_quantity*$product->price, 2).' total)  Exc. VAT');
            }

            $subscriptionInfo->addData('Nominal Code', $product->invoice_nominal_code);
            $subscriptionInfo->addData('Enabled?', ($subscription->enabled == 1 ? 'Yes' : 'No'));

            $startDate = \DateTime::createFromFormat('Y-m-d', $subscription->date_starts);
            $subscriptionInfo->addData('Started', $startDate->format('d M Y'));

            $lastBillingDate = \DateTime::createFromFormat('Y-m-d', $subscription->last_billing_date);
            if ($lastBillingDate instanceof \DateTime){
                $subscriptionInfo->addData('Last Billed on', $lastBillingDate->format('d M Y'));
            } else {
                $subscriptionInfo->addData('Last Billed on', 'N/A');
            }

            $nextBillingDate = \DateTime::createFromFormat('Y-m-d', $subscription->next_billing_date);
            $subscriptionInfo->addData('Next Billed on', $nextBillingDate->format('d M Y'));

            list($userInfo, $subscriptionInfo) = $entityData = Hook::processHook('modify_subscription_display_fields', $subscription, $userInfo, $subscriptionInfo);

            $components = [];
            $components[] = genericComponents::ContentTitle("User");
            $components[] = $userInfo;
            $components[] = genericComponents::ContentTitle("Subscription");
            $components[] = $subscriptionInfo;

            return genericComponents::dashboardBlockWrapper($components);
        } else {
            return genericComponents::dashboardBlockWrapper([]);
        }
    }

    public static function subscriptionDetailsTable(subscriptionEntity $subscriptionEntity)
    {

        $subscriptions = $subscriptionEntity->getWithProducts([$subscriptionEntity->id]);
        $subscriptionInfo = new DisplayTable();
        $subscriptionInfo->addTitle('Subscription Information:');
        if (isset($subscriptions[0])) {
            $subscriptionDetails = $subscriptions[0];
            $subscriptionInfo->addData('Product Name', $subscriptionDetails->product_name);
            $subscriptionInfo->addData('Price per month', '<strong>£'.number_format($subscriptionDetails->price,2) . '</strong> ('.number_format($subscriptionDetails->price*1.2,2).' inc. VAT)');
            $subscriptionInfo->addData('Last Billing Date', $subscriptionDetails->last_billing_date);
            $subscriptionInfo->addData('Next Billing Date', $subscriptionDetails->next_billing_date);
            $subscriptionInfo->addData('Start Date', $subscriptionDetails->start_date);
        }
        $subscriptionInfo = Hook::processHook('modify_subscription_details_table', $subscriptionEntity, $subscriptionInfo);

        return $subscriptionInfo;
    }



    public static function userSubscriptionsTile($userEntity=null){

        $currentUser = currentUser::getCurrentUser();

        $subscriptionsList = (new ColWrapper())
            ->addClass('bg-white col-12');
        $subscriptionTable = (new CardEntityFilteredDisplayTable())
            ->addTitle('Subscriptions')
            ->src(Routes::getRoutePattern('subscription.data.basic'). (isset($userEntity->email) ? '?userEmail='.$userEntity->email : ''))
            ->displayPagination(FALSE)
            ->addProperty('refreshButton', '<i class="fa-light fa-arrows-rotate"></i>')
            ->displayShortTotals(FALSE)
            ->setRefreshTag('user-subscriptions-table')
            ->hideIdColumn();
        //$subscriptionTable->hideIdColumn();
        if($currentUser->isAllowed('ManageUsers') || $currentUser->isAllowed('UpdateSubscriptions')) {
            $path = Routes::getRoutePattern('subscriptionEntity.display.put.override', [], false);
            $subscriptionTable->addDropMenuModal('Edit', 'Edit Subscription', [], 'subscriptionEntity.display.put'.($path?'.override':''));
            $subscriptionTable->addDropMenuModal('Suspend', 'Suspend Subscription', [], 'subscriptionDisplay.suspend', (object)['col' => 'status', 'val' => 'Active']);
        } else {
            $subscriptionTable->addDropMenuModal('Cancel', 'Cancel Subscription', [], 'subscriptionDisplay.suspend', (object)['col' => 'status', 'val' => 'Active']);
        }

        $helpComponents = [
            (new ContentTitle())->addClass('text-black text-start help-modal-content-title')->addTitle('A list of recent payments, and their status'),
            (new DisplayTable())->addClass('text-black text-start help-modal-display-table')->addRows([
                ['Subscription ID', 'The internal ID of your subscription. We use this to help with support queries. It also helps you to match your SIM cards with their subscriptions.'],
                ['Created', 'The date your subscription was created'],
                ['Next Billing Date', 'The date we will take your next payment for this subscription'],
                ['Bundle', 'Your chosen monthly subscription product'],
                ['Type', 'The type of subscription. CC (Credit/Debit Card), DD (Direct Debit)'],
                ['Amount', 'The billing amount of the subscription (Inc VAT)'],
                ['Status', 'The status of your subscription. Active, Disabled, Suspended'],
                ['Actions', 'The actions menu. Click the three dots to open the actions menu to manage your subscription'],
            ])
        ];
        $subscriptionTable->addHeaderModal('Subscriptions Table', $helpComponents);

        $subscriptionsList->addComponent($subscriptionTable);
        return $subscriptionsList;

    }

    public static function subscriptionInvoicesTile($subscriptionId, $cssClass="col-12")
    {
        return (new ColWrapper())
            ->addClass($cssClass)
            ->addComponent((new CardEntityFilteredDisplayTable())
                ->addTitle('Latest Invoices')
                ->src(Routes::getRoutePattern('invoice.subscription.data.basic'). '?subscriptionId='.$subscriptionId)
                ->displayPagination(false)
                ->displayShortTotals(false)
                ->hideIdColumn()
                ->addDropMenuItem('provider.invoices.view', 'view', '', 'get', '_blank')
            );
    }

    public static function suspendSubscriptionTile(subscriptionEntity $subscriptionEntity)
    {
        $subscriptionService = new subscriptionService();
        $config = Singleton::getInstance();
        $suspendStatusObject = $subscriptionService->suspendedStatus($subscriptionEntity);

        $colWrapper = (new ColWrapper())->addComponent((new ContentTitle())->addContent($suspendStatusObject->label))->addClass('my-3 fw-bold');

        $currentUser = currentUser::getCurrentUser();
        if(!$currentUser->isAllowed('ManageUsers') && !$currentUser->isAllowed('UpdateSubscriptions')){
            $labels = ['Cancel', 'Cancellation', 'Cancelled'];
        } else {
            $labels = ['Suspend', 'Suspension', 'Suspended'];
        }

        $button = (new SimpleButton());
        $button->addClass('btn-'.$suspendStatusObject->bsStyle);
        if ($suspendStatusObject->canSuspend && isset($suspendStatusObject->suspensionDate)) {
            $button->addText('Schedule '.$labels[1].' for '.$suspendStatusObject->suspensionDate->format('jS M Y'));
            $button->addRoute($config->app->site->backend_domain . Routes::getRoutePattern('subscription.suspend', ['id' => $subscriptionEntity->id, 'cancellationDate' => $suspendStatusObject->suspensionDate->format('Y-m-d')]));
            $button->addProperty('asynch', 'POST');
        } elseif ($suspendStatusObject->canSuspend) {
            $button->addText($labels[0] . ' Now');
            $button->addRoute($config->app->site->backend_domain . Routes::getRoutePattern('subscription.suspend', ['id' => $subscriptionEntity->id]));
            $button->addProperty('asynch', 'POST');
        } else {
            $button->addText('Already '.$labels[2]);
        }


        $colWrapper->addComponent($button);

        return $colWrapper;
    }


}