<?php
namespace apexl\Io\modules\subscription;

use apexl\Io\includes\Controller;
use apexl\Io\includes\Hook;
use apexl\Io\includes\Module;
use apexl\Io\includes\System;
use apexl\Io\modules\subscription\callbacks\entityLoadCallback;
use apexl\Io\modules\subscription\callbacks\entityStoreCallback;
use apexl\Io\modules\subscription\controllers\subscriptionController;
use apexl\Io\modules\subscription\entities\subscriptionEntity;
use apexl\Io\modules\subscription\entities\subscriptionPaymentEntity;
use apexl\Io\modules\user\classes\userManagedApiModule;
use apexl\Io\modules\user\services\Permissions;

class subscriptionModule extends userManagedApiModule {

    public function __construct()
    {
        parent::__construct();
        $this->registerHooks();
    }

    public function routes(){
        $this->addProtectedEntityRoutes(new subscriptionEntity(), [
            'get' => [Controller::class.':get', 'ViewSubscriptions'],
            'put' => [Controller::class.':put', 'UpdateSubscriptions'],
            'post' => [Controller::class.':post', 'CreateSubscriptions'],
            'delete' => [Controller::class.':delete', 'DeleteSubscriptions'],
        ]);
        $this->addProtectedEntityRoutes(new subscriptionPaymentEntity(), [
            'get' => [Controller::class.':get', 'ViewSubscriptions'],
            'put' => [Controller::class.':put', 'UpdateSubscriptions'],
            'post' => [Controller::class.':post', 'CreateSubscriptions'],
            'delete' => [Controller::class.':delete', 'DeleteSubscriptions'],
        ]);

        // Data Routes
        $this->addProtectedDataRoute('get', 'subscription.wordpress.order.data', 'forms/wordpress-order-data', subscriptionController::class.':subscriptionListTableData', 'ViewSubscriptions');
        $this->addProtectedDataRoute('get', 'subscription.data.basic', 'data/basic', subscriptionController::class.':subscriptionListTableDataBasic', 'ViewSubscriptions');
        $this->addProtectedDataRoute('get', 'subscription.data.troubleshoot', 'data/troubleshoot', subscriptionController::class.':troubleshootData', 'UpdateSubscriptions');


        // Action Routes
        $this->addProtectedActionRoute('post', 'subscription.update', 'subscription/update', subscriptionController::class.':updateSubscription', 'UpdateSubscriptions');
        $this->addProtectedActionRoute('post', 'subscription.create', 'subscription/create', subscriptionController::class.':createSubscription', 'CreateSubscriptions');
        $this->addProtectedActionRoute('post', 'subscription.suspend', 'subscription/suspend/{id}[/{cancellationDate}]', subscriptionController::class.':suspendSubscription', 'IsLoggedIn');
        $this->addProtectedActionRoute('post', 'subscription.reenable', 'subscription/reenable/{id}', subscriptionController::class.':reenableSubscription', 'IsLoggedIn');

        $this->addProtectedActionRoute('put', 'subscription.remote.update', 'remote-update', subscriptionController::class.':remoteUpdate', 'AllowAll');
    }

    public function addMiddleware(){
        $this->Io->add(\apexl\Io\middleware\subscription\subscriptionController::class);
    }

    public function registerPermissions(Permissions $permissions){
        $permissions->registerPermission('ViewSubscriptions', 'View Subscriptions', 'Subscriptions');
        $permissions->registerPermission('CreateSubscriptions', 'Create Subscriptions', 'Subscriptions');
        $permissions->registerPermission('UpdateSubscriptions', 'Update Subscriptions', 'Subscriptions');
        $permissions->registerPermission('DeleteSubscriptions', 'Delete Subscriptions', 'Subscriptions');
    }


    public function registerHooks()
    {
        Hook::registerCallback('preEntityUpdate', entityStoreCallback::class.':update');
        Hook::registerCallback('preEntityInsert', entityStoreCallback::class.':insert');
        Hook::registerCallback('entityLoadMultipleQuery', entityLoadCallback::class.':loadQuery');
        Hook::registerCallback('entityLoadMultipleFields', entityLoadCallback::class.':loadFields');
        Hook::registerCallback('entityLoadQuery', entityLoadCallback::class.':loadQuery');
        Hook::registerCallback('entityLoadFields', entityLoadCallback::class.':loadFields');
    }

    public function schema(){
        return System::loadSchema(__DIR__.'/schema/schema.json');
    }

    public function install(){
        $schema = $this->schema();
    }
}