<?php

namespace apexl\Io\modules\subscription\entities\operators;

use apexl\Io\operators\entityDatabaseOperator;

class subscriptionChangeOperator extends entityDatabaseOperator{
    public function __construct($table, $primaryKey = 'id')
    {
        parent::__construct($table, $primaryKey);
    }

    public function getMostRecentForSubscription($subscriptionId)
    {
        $entity = $this->vault
            ->select($this->dbTable)
            ->fields($this->dbTable.'.*')
            ->where('subscription_id', $subscriptionId)
            ->orderBy('timestamp', 'DESC')
            ->limit(1)
            ->execute()
            ->fetchAssoc();

        return ['updateEntityData' => true, 'data' => $entity];
    }

    public function getByDates(\DateTimeInterface $startDateTime, \DateTimeInterface $endDateTime)
    {
        return $this->vault
            ->select($this->dbTable)
            ->fields($this->dbTable.'.*')
            ->where('timestamp', $startDateTime->format('Y-m-d H:i:s'), ">=")
            ->where('timestamp', $endDateTime->format('Y-m-d H:i:s'), "<=")
            ->execute()
            ->fetchAll();
    }
}