<?php
namespace apexl\Io\modules\subscriptionDisplay\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\Routes;
use apexl\Io\includes\System;
use apexl\Io\modules\company\entities\companyEntity;
use apexl\Io\modules\display\components\ButtonBar;
use apexl\Io\modules\display\components\EntityFilteredDisplayTable;
use apexl\Io\modules\display\components\FormComponent;
use apexl\Io\modules\display\components\genericComponents;
use apexl\Io\modules\display\components\RowWrapper;
use apexl\Io\modules\display\includes\Forms;
use apexl\Io\modules\display\services\Render;
use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\checkboxField;
use apexl\Io\modules\formbuilder\includes\inputField;

use apexl\Io\modules\formbuilder\includes\selectField;
use apexl\Io\modules\product\entities\productEntity;
use apexl\Io\modules\subscription\entities\subscriptionEntity;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\subscriptionDisplay\components\viewTiles;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class adminSubscriptionController extends Controller
{
    /** @var Render */
    protected $render;

    public function __construct(Render $render)
    {
        parent::__construct();
        $this->render = $render;
    }

    public function overview(Request $request, Response $response)
    {
        $table = new EntityFilteredDisplayTable((new subscriptionEntity()));
        $table->src(Routes::getRoutePattern('subscription.wordpress.order.data'));
        $table->setFilters('orderBy[]=missing_sims&orderBy[]=DESC&orderBy[]=subscription.id&orderBy[]=DESC');
        $table->addFilterForm('subscriptionDisplay.form.subscriptions.filter');

        //render
        $this->render::setPageTitle('Payment Credit Card Subscriptions');
        $this->output::addResponse($request, $this->render::build($table));
        return System::asJson($response);
    }

    public function subscriptionViewSingle(Request $request, Response $response, $id){

        //Subscription tile
        $subscription = new subscriptionEntity();
        $subscription->load($id['id']);

        $buttonBar = new ButtonBar();
        $buttonBar->setEntity($subscription);

        $panel = (new RowWrapper())->addClass('manageForm-wrapper')
            ->addComponent(viewTiles::subscriptionViewTile($subscription));
        $this->render::setPageTitle('Subscription #'.$subscription->id);
        $this->output::addResponse($request, $this->render::build([$buttonBar, $panel]));

        return System::asJson($response);
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @return Response
     * @throws \Exception
     */
    public function createUpdateSubscription(Request $request, Response $response, $args = []){
        $title = 'Create a subscription';
        $subscriptionEntity = new subscriptionEntity();

        if($id = $args[$subscriptionEntity->primaryKey] ?? FALSE){
            $subscriptionEntity->load($id);
            $title = 'Edit subscription #'. $subscriptionEntity->id;
            //Info Bar
            $infoBar = (new RowWrapper());
            $userEntity = new userEntity();
            $userEntity->load($subscriptionEntity->user_id);
            $userTitle = genericComponents::ContentTitle('User', $userEntity->first_name. ' '.$userEntity->last_name, 5, 'col');
            $userEmail = genericComponents::ContentTitle('Email', $userEntity->email, 5, 'col');


            $productEntity = new productEntity();
            $productEntity->load($subscriptionEntity->product_id);
            $productTitle = genericComponents::ContentTitle('Product', $productEntity->product_name, 5, 'col');
            $infoBar->addComponent($userTitle);
            $infoBar->addComponent($userEmail);
            if (class_exists('apexl\Io\modules\company\entities\companyEntity')) {
                $companyEntity = new companyEntity();
                $companyEntity->loadByUser($subscriptionEntity->user_id);
                $companyTitle = genericComponents::ContentTitle('Company', $companyEntity->CompanyName, 5, 'col');
            $infoBar->addComponent($companyTitle);
            }
            $infoBar->addComponent($productTitle);
        }

        $buttonBar = new ButtonBar();
        $buttonBar->setEntity($subscriptionEntity, $args[$subscriptionEntity->primaryKey]?'Edit':'Create');


        $form1 = (new FormComponent())->setID('subscriptionCreate1')->src(Routes::getRoutePattern('subscriptionDisplay.form.subscriptions.createUpdate', $args));
        $form2 = (new FormComponent())->setID('subscriptionCreate2')->src(Routes::getRoutePattern('billing.display.iccid.add.form', ['subscriptionId' => $args['id']]));

        $components = [];
        $components[] = $buttonBar;
        if($args[$subscriptionEntity->primaryKey] ?? FALSE){
            $components[] = $infoBar;
        }

        $components[] = $form1;
        $components[] = $form2;

        $this->render::setPageTitle($title);
        $this->output::addResponse($request, $this->render::build($components));
        return System::asJson($response);
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param $args
     * @return Response
     */
    public function createUpdateSubscriptionForm(Request $request, Response $response, $args){

        $subscription = new subscriptionEntity();
        $subscription->load($args['id']);

        $form = new formEntity();
        $form->setId('UpdateSubscription');
        $form->setMethod('post');
        $form->setActionUrl(Routes::getRoutePattern('subscription.update'));
        $form->setSubmitText('Save');

        $productEntity = new productEntity();
        $products = $productEntity->getAll();
        $options = [];
        foreach ($products as $product) {
            if (trim($product->product_name) != "") {
                $options[$product->id] = $product->product_name;
            }
        }

        $form->addField((new selectField('product_id', $options))->setLabel("Product*")->isRequired()->setValue($subscription->product_id));
        $form->addField((new inputField('product_quantity'))->setLabel('Product Quantity*')->setInputType('number')->isRequired()->setValue($subscription->product_quantity));
        $form->addField((new inputField('next_billing_date'))->setLabel("Next Billing Date*")->addClass('col')->setPlaceholder('yyyy-mm-dd')->isRequired()->setValue($subscription->next_billing_date));
        $form->addField((new checkboxField('enabled'))->setLabel("Enabled?")->addClass('col')->setValue($subscription->enabled ? TRUE : FALSE));
        $form->addField((new inputField("subscription_id"))->setValue($args['id'])->setInputType('hidden'));

        return System::asJson($response, $form->getBuiltFormArray());
    }
}