<?php
namespace apexl\Io\modules\subscriptionDisplay\components;

use apexl\Io\includes\Hook;
use apexl\Io\includes\Routes;
use apexl\Io\modules\display\components\BasicLink;
use apexl\Io\modules\display\components\CardEntityFilteredDisplayTable;
use apexl\Io\modules\display\components\ColWrapper;
use apexl\Io\modules\display\components\ContentTitle;
use apexl\Io\modules\display\components\DisplayTable;
use apexl\Io\modules\display\components\EntityFilteredDisplayTable;
use apexl\Io\modules\display\components\genericComponents;
use apexl\Io\modules\display\components\Modal;
use apexl\Io\modules\product\entities\productEntity;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\services\currentUser;

class viewTiles {

    public static function subscriptionViewTile($subscription){
        if($subscription) {
            $currentUser = currentUser::getCurrentUser();

            $user = new userEntity();
            $user->load($subscription->user_id);
            $product = new productEntity();
            $product->load($subscription->product_id);

            $userInfo = new DisplayTable();
            $userInfo->addData('Email', $user->email);

            $subscriptionInfo = new DisplayTable();
            $subscriptionInfo->addData('Product', $product->product_name);
            $subscriptionInfo->addData('Quantity', $subscription->product_quantity);
            $subscriptionInfo->addData('Monthly Fee', '£'.number_format($product->price, 2) . ' (£'.number_format($subscription->product_quantity*$product->price, 2).' total)  Exc. VAT');
            $subscriptionInfo->addData('Nominal Code', $product->invoice_nominal_code);
            $subscriptionInfo->addData('Enabled?', ($subscription->enabled == 1 ? 'Yes' : 'No'));

            $startDate = \DateTime::createFromFormat('Y-m-d', $subscription->date_starts);
            $subscriptionInfo->addData('Started', $startDate->format('d M Y'));

            $lastBillingDate = \DateTime::createFromFormat('Y-m-d', $subscription->last_billing_date);
            if ($lastBillingDate instanceof \DateTime){
                $subscriptionInfo->addData('Last Billed on', $lastBillingDate->format('d M Y'));
            } else {
                $subscriptionInfo->addData('Last Billed on', 'N/A');
            }

            $nextBillingDate = \DateTime::createFromFormat('Y-m-d', $subscription->next_billing_date);
            $subscriptionInfo->addData('Next Billed on', $nextBillingDate->format('d M Y'));

            list($userInfo, $subscriptionInfo) = $entityData = Hook::processHook('modify_subscription_display_fields', $subscription, $userInfo, $subscriptionInfo);

            $components = [];
            $components[] = genericComponents::ContentTitle("User");
            $components[] = $userInfo;
            $components[] = genericComponents::ContentTitle("Subscription");
            $components[] = $subscriptionInfo;

            return genericComponents::dashboardBlockWrapper($components);
        } else {
            return genericComponents::dashboardBlockWrapper([]);
        }
    }

    public static function userSubscriptionsTile($userEntity=null){

        $currentUser = currentUser::getCurrentUser();

        $subscriptionsList = (new ColWrapper())
            ->addClass('bg-white col-12');
        $subscriptionTable = (new CardEntityFilteredDisplayTable())
            ->addTitle('Subscriptions')
            ->src(Routes::getRoutePattern('subscription.data.basic'). (isset($userEntity->email) ? '?userEmail='.$userEntity->email : ''))
            ->displayPagination(FALSE)
            ->addProperty('refreshButton', '<i class="fa-light fa-arrows-rotate"></i>')
            ->displayShortTotals(FALSE)
            ->hideIdColumn();
        //$subscriptionTable->hideIdColumn();
        if($currentUser->isAllowed('ManageUsers') || $currentUser->isAllowed('UpdateSubscriptions')) {
            $subscriptionTable->addEditButton('subscriptionEntity.display.put');
        }

        $helpComponents = [
            (new ContentTitle())->addClass('text-black text-start help-modal-content-title')->addTitle('A list of recent payments, and their status'),
            (new DisplayTable())->addClass('text-black text-start help-modal-display-table')->addRows([
                ['Subscription ID', 'The internal ID of your subscription. We use this to help with support queries. It also helps you to match your SIM cards with their subscriptions.'],
                ['Created', 'The date your subscription was created'],
                ['Next Billing Date', 'The date we will take your next payment for this subscription'],
                ['Product', 'The type of subscription. CC (Credit/Debit Card), DD (Direct Debit)'],
                ['Type', 'Total payment amount, including VAT'],
                ['Amount', 'The billing amount of the subscription (Inc VAT)'],
                ['Status', 'The status of your subscription. Active, Disabled, Suspended'],
                ['Actions', 'The actions menu. Click the three dots to open the actions menu to manage your subscription'],
            ])
        ];
        $subscriptionTable->addHeaderModal('Subscriptions Table', $helpComponents);

        $subscriptionsList->addComponent($subscriptionTable);
        return $subscriptionsList;

    }

    public static function subscriptionInvoicesTile($subscriptionId, $cssClass="col-12")
    {
        return (new ColWrapper())
            ->addClass($cssClass)
            ->addComponent((new CardEntityFilteredDisplayTable())
                ->addTitle('Latest Invoices')
                ->src(Routes::getRoutePattern('invoice.subscription.data.basic'). '?subscriptionId='.$subscriptionId)
                ->displayPagination(false)
                ->displayShortTotals(false)
                ->hideIdColumn()
            );
    }


}