<?php
namespace apexl\Io\modules\subscriptionDisplay;

use apexl\Io\includes\Controller;
use apexl\Io\modules\display\controllers\displayController;
use apexl\Io\modules\menu\services\Menu;
use apexl\Io\modules\subscription\entities\subscriptionEntity;
use apexl\Io\modules\subscriptionDisplay\controllers\adminSubscriptionController;
use apexl\Io\modules\subscriptionDisplay\forms\filters;
use apexl\Io\modules\user\classes\userManagedDisplayModule;

class subscriptionDisplayModule extends userManagedDisplayModule {
    public function __construct()
    {
        parent::__construct();
    }

    public function routes() {
        $this->addProtectedEntityRoutes((new subscriptionEntity()), [
            'all' => [adminSubscriptionController::class.':overview', 'ViewSubscriptions'],
            'get' => [adminSubscriptionController::class.':subscriptionViewSingle', 'ViewSubscriptions'],
            'put' => [adminSubscriptionController::class.':createUpdateSubscription', 'UpdateSubscriptions'],
        ]);

        $this->addProtectedFormRoute('subscriptionDisplay.form.subscriptions.filter', 'subscription-filter', filters::class.':subscription', 'ViewSubscriptions');
        $this->addProtectedFormRoute('subscriptionDisplay.form.subscriptions.createUpdate', 'createUpdate/{id}', adminSubscriptionController::class.':createUpdateSubscriptionForm', 'UpdateSubscriptions');

        $this->addProtectedAdminRootRoute('GET', 'subscriptionDisplay.suspend', 'subscription/suspend/{id}', adminSubscriptionController::class.':suspendSubscription', 'IsLoggedIn');
    }

    /**
     * @param Menu $menu
     */
    public function registerMenuItems(Menu $menu)
    {
        $menu::addToMenu('subscriptionEntity.display.all', [
            'title' => 'Payment CC Subscriptions',
            'icon' => 'credit-card-front',
            'weight' => 0,
            'parent' => 'payment.display.parent',
        ], 'administration');
    }
}