<?php

namespace apexl\Io\modules\subscription\controllers;

use apexl\Config\Singleton;
use apexl\Io\includes\Controller;
use apexl\Io\includes\System;
use apexl\Io\modules\subscription\entities\subscriptionCreditEntity;
use apexl\Io\modules\subscription\entities\subscriptionEntity;
use apexl\Io\services\pathUtility;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class subscriptionController extends Controller {

    public function __construct(pathUtility $path, Singleton $config)
    {
        parent::__construct();
        $this->path = $path;
        $this->config = $config;
    }

    public function subscriptionListTableData(Request $request, Response $response){
        $params = $request->getQueryParams();
        $entity = new subscriptionEntity();
        $filters = $this->buildFilterConditions($entity, $params);
        $entityData = $entity->loadSubscriptionListByPage($params, $filters, $params['orderBy'] ?? []);

        $entityData['tableHeader'] = ['ID', 'User', 'Product', 'Qty', 'Amount', 'Created', 'Next Billing Date', 'Last Billed', 'State', 'SIMs', 'Transaction Status', 'Order ID', 'Order Status'];

        $rows = [];
        foreach($entityData['data'] as $result){
            $rowSub = new subscriptionEntity();
            $rowSub->load($result->id);
            $subData = $rowSub->getData();
            $orderData = $rowSub->getWordPressOrderStatus($result->remote_order_id);
            $row = [
                'id' => $subData['id'],
                'user' => $subData['user_id'],
                'product' => $subData['product_id'],
                'qty' => $subData['product_quantity'],
                'amount' => '£'.$result->amount,
                'created' => $subData['created'],
                'nbd' => $subData['next_billing_date'],
                'lb' => $subData['last_billing_date'],
                'state' => $subData['enabled'],
                'sims' => $result->assigned_sims,
                'transaction' => $result->status,
                'order' => $result->remote_order_id,
                'order_status' => "<div class='woostatus ".$orderData['status']."'>".$orderData['status'].'</div>'
            ];
            $rows[] = $row;
        }

        $entityData['rows'] = $rows;
        unset($entityData['data']);

        return System::asJson($response, $entityData);
    }
    public function updateSubscription(Request $request, Response $response)
    {
        $body = $request->getParsedBody();
        if(!isset($body->subscription_id) || !$body->subscription_id){
            $this->output::addMessage('subscription.update', 'error', 'Subscription ID missing');
            $this->output::addResponse($request, [], FALSE); // added so we can hook into this elsewhere.
            return System::asJson($response, [], 400);
        }

        $subscription = new subscriptionEntity();
        $subscription->load($body->subscription_id);
        if (!$subscription->id) {
            $this->output::addMessage('subscription.update', 'error', 'Subscription does not exist');
            $this->output::addResponse($request, [], FALSE); // added so we can hook into this elsewhere.
            return System::asJson($response, [], 400);
        }

        $subscription->enabled = $body->enabled ? TRUE : FALSE;
        $subscription->next_billing_date = $body->next_billing_date;
        $subscription->store();
        $this->output::addMessage('subscription.update', 'success', 'Subscription Successfully updated!');

        return System::asJson($response);
    }

    public function remoteUpdate(Request $request, Response $response, $args)
    {
        $body = $request->getParsedBody();
        if (!isset($body->subscriptionId) || !$body->subscriptionId || !isset($body->remoteKey) || !isset($this->config->app->remoteUpdates->key) || $body->remoteKey != $this->config->app->remoteUpdates->key) {
            $this->output::addMessage('subscription.remote.disable', 'error', 'Required information is missing - requirement not stated explicitly for security reasons');
            $this->output::addResponse($request, [], FALSE); // added so we can hook into this elsewhere.
            return System::asJson($response, [], 400);
        }

        $subscriptionEntity = new subscriptionEntity();
        $subscriptionEntity->load((int)$body->subscriptionId);
        if (!isset($subscriptionEntity->id) || !$subscriptionEntity->id) {
            $this->output::addMessage('subscription.remote.disable', 'error', 'Subscription not found');
            $this->output::addResponse($request, [], FALSE); // added so we can hook into this elsewhere.
            return System::asJson($response, [], 400);
        }

        if (isset($body->enabled) && is_bool($body->enabled)) $subscriptionEntity->enabled = $body->enabled;
        if (isset($body->product_price_override)) $subscriptionEntity->product_price_override = $body->product_price_override;
        if (isset($body->product_price_override_ends)) $subscriptionEntity->product_price_override_ends = $body->product_price_override_ends;
        if (isset($body->credits) && is_array($body->credits)) {
            foreach ($body->credits as $credit) {
                $creditEntity = new subscriptionCreditEntity();
                $creditEntity->credit_amount = $credit->amount;
                $creditEntity->subscription_id = (int)$body->subscriptionId;
                $creditEntity->credit_date = $credit->date;
                if (isset($credit->data)) $creditEntity->data = json_encode($credit->data);
                $creditEntity->store();
            }
        }

        $subscriptionEntity->store();

        return System::asJson($response, ['subscriptionsUpdated' => 1, 'data' => ['enabled' => $subscriptionEntity->enabled]]);
    }
}