<?php

namespace apexl\Io\modules\subscription\entities;

use apexl\Io\includes\Entity;
use apexl\Io\includes\System;
use apexl\Io\includes\Utils;
use apexl\Io\modules\company\entities\companyEntity;
use apexl\Io\modules\product\entities\productEntity;
use apexl\Io\modules\subscription\entities\operators\subscriptionOperator;
use apexl\Io\modules\user\entities\userEntity;

class subscriptionEntity extends Entity{


    public function __construct()
    {
        parent::__construct('subscription');
        $this->setRequiredData(['id']);
        $this->setOperator(new subscriptionOperator('subscription'));
        $this->system = System::getInstance();
    }

    public function disable($id){
        return $this->operator->disableSubscription($id);
    }

    public function enable($id){
        return $this->operator->disableSubscription($id);
    }

    /**
     * Function to get all results, paged
     * @param null $params
     * @param array $filters
     * @param array $orderBy
     * @return array
     * @throws \Exception
     */
    public function loadSubscriptionListByPage($params = NULL, $filters = [], $orderBy = []): array
    {
        $this->setPagerLimit(($params['limit'] ?? FALSE));
        $this->setCurrentPagerOffset(($params['offset'] ?? 0));
        //if we have a page param set, calculate offset on the fly.
        if($page = $params['page'] ?? FALSE){
            //if we have a page, assume we need a limit, if its 0 set a default.
            $this->defaultPagerLimit = $this->defaultPagerLimit === 0 ? 25 : $this->defaultPagerLimit;
            $this->currentPagerOffset = ($this->defaultPagerLimit * $page) - $this->defaultPagerLimit;
        }

        $totalResults = count($this->loadAllActiveWithPaymentData($filters));
        $totalPages = $this->defaultPagerLimit == 0 ? 1 : ceil (($totalResults/$this->defaultPagerLimit));

        $data = $this->loadAllActiveWithPaymentData($filters, $orderBy, $this->defaultPagerLimit, $this->currentPagerOffset, FALSE);

        return ['data' => $data, 'totalData' => $totalResults, 'totalPages' => $totalPages, 'totalResults' => count($data)];
    }

    protected function fieldConfig(){
        return [
            "id" => [
                'name' => "ID"
            ],
            "company_id" => [
                'name' => "Company",
                /*'display' => function($company) {
                    if ($company) {
                        $companyEntity = new companyEntity();
                        $companyEntity->loadByUser($company);
                        if ($companyEntity->id ?? FALSE) {
                            return $companyEntity->CompanyName;
                        }
                        return 'Unknown';
                    }
                    return 'N/A';
                }*/
                'display' => function($field){
                    return Utils::HIDE_FROM_DISPLAY;
                }
            ],
            "user_id" => [
                'name' => "User",
                'display' => function($userId) {
                    $userEntity = new userEntity();
                    $userEntity->load($userId);
                    if ($userEntity->id ?? FALSE) {
                        return $userEntity->first_name. ' '.$userEntity->last_name;
                    }
                    return 'Unknown';
                }
            ],
            "product_id" => [
                'name' => "Product",
                'display' => function($productId){
                    $productEntity = new productEntity();
                    $productEntity->load($productId);
                    if ($productEntity->id ?? FALSE) {
                        return $productEntity->product_name;
                    }
                    return 'Unknown';
                }
            ],
            "product_quantity" => [
                'name' => "Product Quantity"
            ],
            "assigned_sims" => [
                'name' => "SIMs",
                'display' => function($value, $entity){
                    if ($entity->product_quantity != $value) {
                        return '<span class="text-danger"><strong>'.$value.'</strong></span>';
                    }
                    return $value;
                }
            ],
            "missing_sims" => [
                'display' => function($field){
                    return Utils::HIDE_FROM_DISPLAY;
                }
            ],
            "date_starts" => [
                'name' => "Setup Date"
            ],
            "date_expires" => [
                'name' => "Expiry Date",
                'display' => function($date){
                    if($date ?? FALSE){
                        return $date;
                    }
                    return 'No Expiry';
                }
            ],
            "grace_period_ends" => [
                'name' => "First Billing Date"
            ],
            "last_billing_date" => [
                'name' => "Last Billed"
            ],
            "next_billing_date" => [
                'name' => "Next Billing Date"
            ],
            "enabled" => [
                'name' => "State",
                'display' => function($enabled){
                    return $enabled ? 'Active' : 'Disabled';
                }
            ],
            "suspended" => [
                'display' => function($field){
                    return Utils::HIDE_FROM_DISPLAY;
                }
            ],
            "max_users" => [
                'display' => function($field){
                    return Utils::HIDE_FROM_DISPLAY;
                }
            ],
            "created" => [
                'name' => 'Created'
            ],
            "code" => [
                'display' => function($field){
                    return Utils::HIDE_FROM_DISPLAY;
                }
            ],
        ];
    }
}