<?php

namespace apexl\Io\modules\subscriptionDisplay\forms;

use apexl\Io\includes\System;
use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\checkboxField;
use apexl\Io\modules\formbuilder\includes\datePickerField;
use apexl\Io\modules\formbuilder\includes\inputField;
use apexl\Io\modules\formbuilder\includes\selectField;
use apexl\Io\modules\product\entities\productEntity;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\services\currentUser;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class filters {
    public function subscription(Request $request, Response $response) {
        $form = new formEntity();
        $form->setId('subscriptionFilter');
        $form->setMethod('post');
        $form->setActionUrl('#');
        $form->setSubmitText('Filter');
        $form->includeClearButton(TRUE)->setClearButtonText('Reset');
        $currentUser = currentUser::getCurrentUser();
        if($currentUser->isAllowed('ViewAllAccounts')) {
            $form->addFieldToGroup((new selectField('user_id'))->buildOptionsFromEntities((new userEntity())->loadMultiple(), 'id', 'email')->setLabel("User Email")->addClass('col')->setPlaceholder('Select User Email'), 'subscription');
        }
        $form->addFieldToGroup((new selectField('product_id'))->buildOptionsFromEntities((new productEntity())->loadMultiple(), 'id', 'product_name')->setLabel("Product")->addClass('col')->setPlaceholder('Select Product'), 'subscription');
        return System::asJson($response, $form->getBuiltFormArray());
    }

}