<?php

namespace apexl\Io\modules\template\services;

use Mustache\Exception\UnknownTemplateException;
use Mustache\Loader;

class MultipleFilesystemLoader implements Loader
{
    private array $directories = [];
    private string $extension = '.mustache';
    private array $templateCache = [];

    public function __construct(array $options = [])
    {
        if (array_key_exists('extension', $options)) {
            if (empty($options['extension'])) {
                $this->extension = '';
            } else {
                $this->extension = '.' . ltrim($options['extension'], '.');
            }
        }
    }

    public function load($name)
    {
        if (!isset($this->templateCache[$name])) {
            $this->templateCache[$name] = $this->loadFile($name);
        }

        return $this->templateCache[$name];
    }

    protected function loadFile(string $name): string
    {
        $fileName = $this->getFileName($name);

        if (!file_exists($fileName)) {
            throw new UnknownTemplateException($name);
        }

        return file_get_contents($fileName);
    }

    protected function getFileName(string $name): string
    {

        $fileName = $name;
        if (substr($fileName, 0 - strlen($this->extension)) !== $this->extension) {
            $fileName .= $this->extension;
        }

        foreach ($this->directories as $directory) {
            $filePath = sprintf('%s/%s', $directory, $fileName);

            if (file_exists($filePath)) {
                return realpath($filePath);
            }
        }

        throw new UnknownTemplateException($name);
    }
}
