<?php

declare(strict_types=1);

namespace apexl\Io\modules\template\Services;

use apexl\Io\includes\HookManager;
use Mustache\Engine as MustacheEngine;

final readonly class TemplateService
{
    public final const string HOOK__LOADER = 'loader';

    public function __construct(
        private HookManager $hookManager,
        private MustacheEngine $mustache,
        private MultipleFilesystemLoader $loader,
    ) {
        $this->hookManager->processHook(self::HOOK__LOADER, $this->loader);

        $this->mustache->setLoader($this->loader);
    }

    public function template(string $name, array $data = []): string
    {
        return $this->mustache->render($name, $data);
    }

}
