<?php

declare(strict_types=1);

namespace apexl\Io\modules\user\notifiers;

use apexl\Config\Singleton as ConfigSingleton;
use apexl\Io\modules\email\services\templateService;
use apexl\Io\modules\notifier\interfaces\emailNotifierDriverInterface;
use apexl\Io\modules\notifier\notifiers\emailNotifier;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\interfaces\newUserNotifier;
use Exception;

class newUserEmailNotifier extends emailNotifier implements newUserNotifier
{
    private userEntity $user;

    public function __construct(emailNotifierDriverInterface $driver, userEntity $user)
    {
        parent::__construct($driver);

        $this->user = $user;
    }

    protected function to(): string
    {
        return $this->user->email;
    }

    protected function subject(): string
    {
        return 'Welcome to the Tile Designer!';
    }

    /**
     * @throws Exception
     */
    protected function body(): string
    {
        return templateService::fetch('new_user', [
            'name' => $this->user->first_name,
            'domain' => ConfigSingleton::getInstance()->app->site->frontend_domain,
        ]);
    }
}
