<?php

namespace apexl\Io\modules\userDisplay\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\Hook;
use apexl\Io\includes\Routes;
use apexl\Io\includes\System;
use apexl\Io\modules\display\components\BasicLink;
use apexl\Io\modules\display\components\ButtonBar;
use apexl\Io\modules\display\components\ContentTitle;
use apexl\Io\modules\display\components\EntityDisplayTable;
use apexl\Io\modules\display\components\EntityFilteredDisplayTable;
use apexl\Io\modules\display\components\FormComponent;
use apexl\Io\modules\display\components\genericComponents;
use apexl\Io\modules\display\components\RowWrapper;
use apexl\Io\modules\display\services\Render;
use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\checkboxField;
use apexl\Io\modules\formbuilder\includes\inputField;
use apexl\Io\modules\subscriptionDisplay\components\viewTiles;
use apexl\Io\modules\user\entities\userNoteEntity;
use apexl\Io\modules\userDisplay\components\dashboardTiles;
use apexl\Io\modules\userDisplay\components\roleEntityDisplayTile;
use apexl\Io\modules\userDisplay\components\userEntityDisplayTile;
use apexl\Io\modules\userDisplay\forms\createNoteForm;
use apexl\Io\modules\userDisplay\forms\forgottenPasswordForm;
use apexl\Io\modules\userDisplay\forms\loginAsUserForm;
use apexl\Io\modules\userDisplay\forms\loginForm;
use apexl\Io\modules\user\entities\roleEntity;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\services\currentUser;
use apexl\Io\services\Output;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class userNoteController extends Controller
{
    protected $currentUser;
    protected $render;

    public function __construct(Render $render, currentUser $currentUser)
    {
        parent::__construct();
        $this->currentUser = $currentUser::getCurrentUser();
        $this->render = $render;
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param $args
     * @return Response
     * @throws \Exception
     */
    public function userNotes(Request $request, Response $response, $args)
    {
        $userEntity = userEntity::load($args['id']);
        $components = [];
        $components[] = (new rowWrapper())->addComponent(
            (new FormComponent())->src(Routes::getRoutePattern('user.display.forms.createNote', ['userId' => $args['id']]))
                ->addClass('create-user-note-form')->setID('createUserNote')
        );
        $components[] = (new rowWrapper())->addComponent(
                (new EntityDisplayTable((new userNoteEntity())))
                    ->src(Routes::getRoutePattern('user-note.data.basic', ['userId' => $args['id']]))
                    ->addClass('user-notes-table')
                    ->displayPagination(FALSE)
        );

        $this->render::setPageTitle('Notes about user '.$userEntity->getNiceName());
        $this->output::addResponse($request, $this->render::build($components));

        return System::asJson($response);
    }

    public function createNoteForm(Request $request, Response $response, $args)
    {
        return System::asJson($response, (new createNoteForm())->createNoteForm($args));
    }

}
