<?php

namespace apexl\Io\modules\user\entities\operators;

use apexl\Io\operators\entityDatabaseOperator;

class userOperator extends entityDatabaseOperator
{
    public function __construct($table, $primaryKey = 'id')
    {
        parent::__construct($table, $primaryKey);
    }

    public function getUserByEmail($email)
    {
        $entity = $this->vault->select($this->dbTable)->fields()->where('email', $email)->execute()->fetchAssoc();
        return ['updateEntityData' => true, 'data' => $entity];
    }

    public function getUsersByRid($rid)
    {
        return $this->vault->select($this->dbTable)->fields()->where('roles', '%"'.$rid.'"%', 'LIKE')->execute()->fetchAll();
    }

    public function newForgottenPasswordLink($email, $string)
    {
        $fields = [
            'email' => $email,
            'hash' => $string,
            'created' => time(),
            'used' => 0
        ];
        $this->vault->insert('password_reset')->fields($fields)->execute();
    }

    public function markForgottenPasswordLinkUsed($hash)
    {
        $this->vault->update('password_reset')->fields(['used' => 1])->where('hash', $hash)->execute();
    }

    public function getForgottenPasswordLink($string)
    {
        return $this->vault->select("password_reset")->fields()->where('hash', $string)->execute()->fetchAssoc();
    }

    public function fetchAll()
    {
        return $this->vault->select($this->dbTable)->fields(['id, email, remote_user_id'])->execute()->fetchAll();
    }

    public function getUsers($userIds)
    {
        $users = $this->vault->select($this->dbTable)->fields()->where('id', $userIds, 'IN')->execute()->fetchAll();

        $indexed = [];
        foreach ($users as $user) {
            $indexed[$user->id] = $user;
        }

        return $indexed;
    }
}
