<?php

namespace apexl\Io\modules\user\controllers;

use apexl\hashing\Hash;
use apexl\Io\includes\Controller;
use apexl\Io\includes\Hook;
use apexl\Io\includes\Routes;
use apexl\Io\includes\System;
use apexl\Io\modules\email\services\templateService;
use apexl\Io\modules\user\entities\refreshTokenEntity;
use apexl\Io\modules\user\entities\sessionEntity;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\entities\userNoteEntity;
use apexl\Io\modules\user\services\currentUser;

use apexl\Io\modules\user\services\userTools;
use apexl\Io\services\Logger;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class userNoteController extends Controller
{
    protected $database;
    /** @var userEntity */
    protected userEntity $currentUser;

    public function __construct(currentUser $currentUser, userTools $userTools)
    {
        parent::__construct();
        $this->currentUser = $currentUser::getCurrentUser();
    }

    public function createUserNote(Request $request, Response $response)
    {
        $body = $request->getParsedBody();

        if (empty($body) || !isset($body->content) || !isset($body->userId)) {
            $this->output::addMessage('user.login.validation', 'error', "Missing data - cannot create note.");
            $this->output::addResponse($request, [], false); //added so we can hook into this elsewhere.
            return System::asJson($response, [], 400);
        }

        $userNoteEntity = new userNoteEntity();
        $userNoteEntity->user_id = $body->userId;
        $userNoteEntity->content = $body->content;
        $userNoteEntity->store();

        if ($userNoteEntity-> id > 0) {
            $data = [];
            $data['refreshGlobal'] = true;
            $this->output::addMessage($this->path->getRouteName($request).'.success', 'success', "Note successfully added");
            return System::asJson($response, ['refreshGlobal' => true]);
        }

        $this->output::addMessage($this->path->getRouteName($request).'.failure', 'error', "Note could not be created");
        $this->output::addResponse($request, [], false); //added so we can hook into this elsewhere.
        return System::asJson($response, [], 400);
    }

    public function userNoteListTableDataBasic(Request $request, Response $response, $args){
        $params = $request->getQueryParams();
        $userTools = new userTools();
        $userNoteEntity = new userNoteEntity();
        $notes = $userNoteEntity->getForUser($args['userId']);
        $entityData = [];
        $entityData['tableHeader'] = [/*'#',*/ 'Note', 'Created By', 'Created'];
        $rows = [];
        foreach($notes as $note){
            $row = [
                //'id' => $note->id,
                'note' => $note->content,
                'createdBy' => $userTools->getEntityEditorName($note, 'created'),
                'created' => (\DateTime::createFromFormat('U', $note->created))->format('H:i \o\n d M Y'),
            ];
            $rows[] = $row;
        }
        $entityData['rows'] = $rows;
        $entityData['totalData'] = count($rows);

        return System::asJson($response, $entityData);
    }

}
