<?php

namespace apexl\Io\modules\user\classes;

use apexl\Io\includes\Controller;
use apexl\Io\includes\Entity;
use apexl\Io\recommendedIncludes\apiModule;

class userManagedApiModule extends apiModule
{
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Method to add a route, allows the module to have a base path configured and for easy overrides.
     * This Method adds one extra option over the base, to permissions protect a route.
     * @param $verb
     * @param $name
     * @param string $pattern
     * @param $callable
     * @param string $permission
     * @return userManagedApiModule
     */
    protected function addProtectedActionRoute($verb, $name, string $pattern, $callable, string $permission = 'AllowAll')
    {
        $this->addActionRoute($verb, $name, $pattern, $callable);
        $this->route::addRouteArg($name, 'permission', $permission);
        return $this;
    }

    /**
     * @param $verb
     * @param $name
     * @param string $pattern
     * @param $callable
     * @param string $permission
     * @return $this
     */
    protected function addProtectedAdminActionRoute($verb, $name, string $pattern, $callable, string $permission = 'AllowAll')
    {
        $this->addActionRoute($verb, $name, 'admin/'.$pattern, $callable);
        $this->route::addRouteArg($name, 'permission', $permission);
        return $this;
    }

    /**
     * Method to add a route, allows the module to have a base path configured and for easy overrides.
     * This Method adds one extra option over the base, to permissions protect a route.
     * @param $verb
     * @param $name
     * @param string $pattern
     * @param $callable
     * @param string $permission
     * @return userManagedApiModule
     */
    protected function addProtectedDataRoute($verb, $name, string $pattern, $callable, string $permission = 'AllowAll')
    {
        $this->addDataRoute($verb, $name, $pattern, $callable);
        $this->route::addRouteArg($name, 'permission', $permission);
        return $this;
    }

    /**
     * Declare intention to build routes for this entity. Will take defaults if not previously defined.
     * @param Entity $entity
     * @param null $callables
     * @param array|null $patterns
     * @return $this
     */
    protected function addProtectedEntityRoutes(Entity $entity, $callables = null, ?array $patterns = [])
    {
        $this->setEntityPatterns($entity, $patterns);

        foreach ($this->entityPatterns[$entity->getEntityName()] as $verb => $pattern) {
            $this->setEntityCallable($entity, $verb, ($callables[$verb][0] ?? Controller::class.':'.$verb));
        }

        //build the routes.
        $this->buildEntityRoutes($entity);
        //protect the built routes
        foreach ($this->entityPatterns[$entity->getEntityName()] as $verb => $pattern) {
            $this->route::addRouteArg($entity->getEntityName().'.'.strtolower($verb), 'permission', $callables[$verb][1] ?? 'AllowAll');
            $this->route::addRouteArg($entity->getEntityName().'.'.strtolower($verb), 'entity', get_class($entity));
        }
        return $this;
    }
}
