<?php

namespace apexl\Io\modules\user\controllers;

use apexl\hashing\Hash;
use apexl\Io\includes\Controller;
use apexl\Io\includes\Hook;
use apexl\Io\includes\Routes;
use apexl\Io\includes\System;
use apexl\Io\modules\email\services\templateService;
use apexl\Io\modules\user\entities\refreshTokenEntity;
use apexl\Io\modules\user\entities\sessionEntity;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\entities\userNoteEntity;
use apexl\Io\modules\user\entities\userNotificationEntity;
use apexl\Io\modules\user\services\currentUser;

use apexl\Io\modules\user\services\userTools;
use apexl\Io\services\Logger;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class userNotificationController extends Controller
{
    protected $database;
    /** @var userEntity */
    protected userEntity $currentUser;

    public function __construct(currentUser $currentUser, userTools $userTools)
    {
        parent::__construct();
        $this->currentUser = $currentUser::getCurrentUser();
    }

    public function markAllAsRead(Request $request, Response $response)
    {
        $currentUser = currentUser::getCurrentUser();
        $userNotificationEntity = new userNotificationEntity();
        $userNotificationEntity->markAllAsRead($currentUser->id);

        return System::asJson($response, ['unreadCount' => 0]);
    }


}
