<?php

namespace apexl\Io\modules\userDisplay\forms;

use apexl\Io\includes\Routes;
use apexl\Io\includes\System;
use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\inputField;
use apexl\Io\modules\formbuilder\includes\linkField;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class loginAsUserForm {

    public function loginAsUserForm($args=null) {

        $form = new formEntity();
        $form->setId('loginAsUser');
        $form->setMethod('post');
        $form->setActionUrl(Routes::getRoutePattern('user.loginAsUser'));
        $form->setSubmitText(System::getVariable('user_login_as_user_submit_text') ?? 'Sign in as this User');
        $form->addField((new inputField('userId'))->setInputType('hidden')->setValue($args['userId'])->isRequired());
        if (isset($args['redirectToRoute'])) {
            $form->addField((new inputField("redirectToRoute"))->setValue($args["redirectToRoute"])->setInputType('hidden'));
        }

        return $form->getBuiltFormArray();
    }
}