<?php

/** @noinspection PhpUnused */

namespace apexl\Io\modules\userDisplay;

use apexl\Io\includes\Hook;
use apexl\Io\modules\display\controllers\displayController;
use apexl\Io\modules\menu\services\Menu;
use apexl\Io\modules\user\classes\userManagedDisplayModule;
use apexl\Io\modules\user\entities\roleEntity;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\userDisplay\callbacks\pages;
use apexl\Io\modules\userDisplay\callbacks\redirects;
use apexl\Io\modules\userDisplay\controllers\userController;
use apexl\Io\modules\userDisplay\controllers\rolesController;
use apexl\Io\modules\userDisplay\forms\filters;

class userDisplayModule extends userManagedDisplayModule
{
    public function __construct()
    {
        parent::__construct();
    }

    public function routes()
    {
        //Page routes.
        $this->addProtectedRootRoute('GET', 'user.display.login', 'login[/{loginMessageType}]', userController::class.':loginPage');
        $this->addProtectedRootRoute('GET', 'user.display.register', 'register', userController::class.':registerPage');
        $this->addProtectedRootRoute('GET', 'user.display.forgot-password', 'forgot-password', userController::class.':forgotPasswordPage');
        $this->addProtectedRootRoute('GET', 'user.display.forgot-password.check-email', 'forgot-password/check-email', userController::class.':forgotPasswordCheckEmail');
        $this->addProtectedRootRoute('GET', 'user.display.settings', 'user/settings', userController::class.':userSettingsPage', 'IsLoggedIn');
        $this->addProtectedRootRoute('GET', 'user.display.dashboard', 'users', userController::class.':userHome', 'IsLoggedIn');
        //$this->route->get('/users', userController::class.':userHome', 'ViewUsers')->addToMenu("User Dashboard", "", '/usersParent');

        //These are display routes, so in this instance VERBS are used to dictate the pattern, NOT the HTTP verb.
        $this->addProtectedEntityRoutes(
            (new userEntity()),
            [
                'all' => [userController::class.':userList', 'ViewUsers'],
                'get' => [userController::class.':userViewSingle', 'ViewUsers'],
                'put' => [userController::class.':updateView', 'UpdateUsers'],
                'post' => [userController::class.':create', 'CreateUsers'],
                'delete' => [displayController::class.':delete', 'DeleteUsers'],
            ]
        );

        $this->addProtectedEntityRoutes(
            (new roleEntity()),
            [
                'all' => [rolesController::class.':roleList', 'ViewRoles'],
                'get' => [rolesController::class.':view', 'ViewRoles'],
                'put' => [rolesController::class.':updateView', 'UpdateRoles'],
                'post' => [rolesController::class.':create', 'CreateRoles'],
                'delete' => [displayController::class.':delete', 'DeleteRoles'],
            ]
        );

        //data routes
        $this->addProtectedDataRoute('GET', 'userEntity.data.summery', 'user-summery', userController::class.':userSummery', 'ViewUsers');
        $this->addProtectedDataRoute('GET', 'roleEntity.data.summery', 'role-summery', rolesController::class.':roleSummery', 'ViewRoles');

        //Forms - Users
        $this->addProtectedFormRoute('user.display.forms.login', 'loginForm[/{redirectToRoute}]', userController::class.':loginForm');
        $this->addProtectedFormRoute('user.display.forms.forgottenPassword', 'forgottenPasswordForm', userController::class.':forgotPasswordForm');
        $this->addProtectedFormRoute('user.display.forms.register', 'registerForm', userController::class.':registerForm');
        $this->addProtectedFormRoute('user.display.forms.userSettings', 'userSettings', userController::class.':userSettingsForm', 'IsLoggedIn');
        $this->addProtectedFormRoute('user.display.forms.createUpdate', 'userCreate[/{id}]', userController::class.':userEditForm', 'CreateUsers');
        $this->addProtectedFormRoute('user.display.forms.loginAsUser', 'loginAsUserForm/{userId}', userController::class.':loginAsUserForm', 'ManageUsers');

        //Forms - Roles
        $this->addProtectedFormRoute('role.display.forms.createUpdate', 'roleCreate[/{id}]', rolesController::class.':manageForm', 'CreateRoles');

        //Filter forms
        $this->addProtectedFormRoute('user.display.forms.filters.userFilter', 'user-filter', filters::class.':userFilter', 'ViewUsers');
    }

    public function registerMenuItems(Menu $menu)
    {
        // Navigation Menu
        $menu::addToMenu('home', [
            'title' => 'Home',
            'icon' => 'home',
            'weight' => -10
        ]);

        //Administration menu
        $menu::addToMenu('user.admin', [
            'title' => 'Users',
            'icon' => 'users',
            'weight' => 0,
        ], 'administration');

        $menu::addToMenu('user.display.dashboard', [
            'title' => 'Overview',
            'weight' => -10,
            'parent' => 'user.admin',
            'icon' => 'user-chart'
        ], 'administration');

        $menu::addToMenu('userEntity.display.all', [
            'title' => 'View all users',
            'weight' => - 9,
            'parent' => 'user.admin',
            'icon' => 'users'
        ], 'administration');

        $menu::addToMenu('userEntity.display.post', [
            'title' => 'Create a user',
            'weight' => - 8,
            'parent' => 'user.admin',
            'icon' => 'users-medical'
        ], 'administration');

        $menu::addToMenu('roleEntity.display.all', [
            'title' => 'View all roles',
            'weight' => - 9,
            'parent' => 'user.admin',
            'icon' => 'user-secret',
        ], 'administration');

        $menu::addToMenu('roleEntity.display.post', [
            'title' => 'Create a role',
            'weight' => - 8,
            'parent' => 'user.admin',
            'icon' => 'user-unlock',
        ], 'administration');
    }

    /**
     * Register callbacks.
     * @see modules:initialiseActiveModuleServices();
     */
    public function registerCallbacks()
    {
        Hook::registerCallback('postAuth', pages::class.':display');
        Hook::registerCallback('addResponse', redirects::class.':redirects');
    }
}
