<?php

declare(strict_types=1);

namespace apexl\Io\modules\userDisplay\hooks;

use apexl\Io\hooks\AbstractHook;
use apexl\Io\includes\Routes;
use apexl\Io\services\Output;
use Psr\Http\Message\ResponseInterface;

final readonly class RegisterRedirects extends AbstractHook
{

    static protected function hooks(): array
    {
        return [
            'addResponse',
        ];
    }

    public function __invoke(ResponseInterface $response, string $route, Output $output): void
    {
        switch ($route) {
            case 'user.login':
                if ($response['success']) {
                    $output::addMetadata(
                        'user.login.redirect',
                        'redirect',
                        Routes::getRoutePattern('home')
                    );
                }
                break;
            case 'user.logout':
                if ($response['success']) {
                    $output::addMetadata(
                        'user.logout.redirect',
                        'redirect',
                        Routes::getRoutePattern('home')
                    );
                }
                break;
            case 'userEntity.post':
                if ($response['success']) {
                    //if this is a registration, redirect the user to home

                    //for all other post events, redirect to the /user/<id> page.
                    $entityId = $output::getMetadata('userEntity.post.complete')['entityId'] ?? false;
                    $output::addMetadata(
                        'userEntity.post.redirect',
                        'redirect',
                        Routes::getRoutePattern('userEntity.display.get', ['id' => $entityId])
                    );
                }
                break;
            case 'userEntity.put':
                if ($response['success']) {
                    //redirect to the user info page for the updated user.
                    $entityId = $output::getMetadata('userEntity.put.complete')['entityId'] ?? false;
                    $output::addMetadata(
                        'userEntity.put.redirect',
                        'redirect',
                        Routes::getRoutePattern('userEntity.display.get', ['id' => $entityId])
                    );
                }
                break;
            case 'user.forgot-password.hash':
                if ($response['success']) {
                    $output::addMetadata(
                        'userEntity.post.redirect',
                        'redirect',
                        Routes::getRoutePattern('user.display.settings')
                    );
                }
                break;
            case 'roleEntity.post':
                $output::addMetadata(
                    'roleEntity.post.redirect',
                    'redirect',
                    Routes::getRoutePattern('roleEntity.display.all')
                );
                break;
            case 'roleEntity.put':
                //redirect to the user info page for the updated role.
                $entityId = $output::getMetadata('core.controller.put-post.entityId')['entityId'] ?? false;
                $output::addMetadata(
                    'roleEntity.put.redirect',
                    'redirect',
                    Routes::getRoutePattern('roleEntity.display.get', ['id' => $entityId])
                );
                break;
            case 'roleEntity.delete':
                //redirect to the user info page for the updated role.
                $output::addMetadata(
                    'roleEntity.delete.redirect',
                    'redirect',
                    Routes::getRoutePattern('roleEntity.display.all')
                );
                break;
        }
    }
}
