<?php

namespace apexl\Io\modules\userDisplay\components;

use apexl\Io\includes\Routes;
use apexl\Io\modules\component\entities\componentEntity;
use apexl\Io\modules\display\components\genericComponents;
use apexl\Io\modules\user\services\currentUser;

class dataTables
{
    public static function userTableShortlist($filters = '')
    {
        return self::DataTableDisplayTile(Routes::getRoutePattern('userEntity.get').$filters, Routes::getRoutePattern('userEntity.all'), 'UpdateUsers', 'DeleteUsers');
    }

    public static function userRoleShortlist($filters = '')
    {
        return self::DataTableDisplayTile(Routes::getRoutePattern('roleEntity.get').$filters, Routes::getRoutePattern('roleEntity.all'), 'CreateRoles', 'DeleteRoles');
    }

    public static function DataTableDisplayTile($dataSrc, $buttonRoute, $editRole = false, $deleteRole = false): componentEntity
    {
        $currentUser = currentUser::getCurrentUser();
        $table = genericComponents::dataTable($dataSrc);
        if ($access = ($editRole ? $currentUser->isAllowed($editRole) : true)) {
            $processButton = genericComponents::tableButton($buttonRoute, 'edit', '', 'btn table__btn table__btn-edit', 'edit');
            $table->addComponent($processButton);
        }
        if ($access = ($deleteRole ? $currentUser->isAllowed($deleteRole) : true)) {
            $deleteButton = genericComponents::tableButton($buttonRoute, 'trash-alt', '', 'btn table__btn table__btn-delete', 'delete');
            $table->addComponent($deleteButton);
        }

        return $table;
    }
}
