<?php

declare(strict_types=1);

namespace apexl\Io\modules\user\collections;

use app\module\newtonsTrailers\Interface\PermissionInterface;
use Arrayy\Collection\AbstractCollection;

class permissionCollection extends AbstractCollection
{
    public static function createFromQueryResult(array $result): permissionCollection
    {
        return self::createFromArray(
            array_map(
                fn($result) => unserialize($result->permission),
                $result
            )
        );
    }

    public function getType(): string
    {
        return PermissionInterface::class;
    }
}
