<?php

declare(strict_types=1);

namespace apexl\Io\modules\user\services;

use apexl\Config\Singleton as Config;
use apexl\Io\modules\user\exceptions\ClientCredentialsValidationException;

readonly final class ClientCredentialValidator
{
    public function __construct(
        private Config $config
    ) {
    }

    /**
     * @throws ClientCredentialsValidationException
     */
    public function assertValid(string $clientId, string $clientSecret): void
    {
        if (
            ($clientId !== $this->config->app->client_id) ||
            ($clientSecret !== $this->config->app->client_secret)
        ) {
            throw new ClientCredentialsValidationException();
        }
    }
}
