<?php

namespace apexl\Io\modules\user\controllers;

use apexl\Io\exceptions\RecordNotFoundException;
use apexl\Io\includes\Controller;
use apexl\Io\includes\System;
use apexl\Io\modules\user\entities\roleEntity;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\services\currentUser;

use apexl\Io\modules\user\services\Permissions;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class rolesController extends Controller
{
    /** @var userEntity */
    protected $currentUser;
    protected $permissions;

    public function __construct(currentUser $currentUser, Permissions $permissions)
    {
        parent::__construct();
        $this->currentUser = $currentUser;
        $this->permissions = $permissions;
    }

    /**
     * @method POST
     * @return String
     * @throws \Exception
     * Automatic install method. Runs the core IO installation process, requires Database user and pass as a minimum to run.
     */
    public function createUpdate(Request $request, Response $response, $args)
    {
        $body = (object)$request->getParsedBody();

        $role = new roleEntity();
        //check if this is an update or create.
        if ($id = $args["id"] ?? false) {
            $role->load($id);
            if ($role->id === null) {
                $this->output::addResponse($request, [], false); //added so we can hook into this elsewhere.
                return $this->throw404($response);
            }
        }

        $role->name = $body->name;
        unset($body->name);

        $existingPermissions = $role->permissions();

        $permissions = $this->permissions->getPermissions();
        foreach ($permissions as $macName => $data) {
            $permission = constant($macName);
            if ($body->$macName == 'true') {
                $role->addPermission($permission);
            } elseif ($body->$macName == 'false') {
                $role->removePermission($permission);
            }
        }

        $role->store();
        $this->output::addMessage($this->path->getRouteName($request).'.validation', 'success', $role->name.' '. ($id ? 'updated' : 'created'));
        $this->output::addResponse($request); //added so we can hook into this elsewhere.
        return System::asJson($response);
    }

    public function getRoles($request, $response, $args)
    {
        return $this->getEntityData($request, $response, $args, (new roleEntity()));
    }
}
