<?php
declare(strict_types=1);

use Phinx\Db\Adapter\AdapterInterface;
use Phinx\Db\Table\ForeignKey;
use Phinx\Db\Table\Index;
use Phinx\Migration\AbstractMigration;

final class CreateUserMeta extends AbstractMigration
{
    /**
     * Change Method.
     *
     * Write your reversible migrations using this method.
     *
     * More information on writing migrations is available here:
     * https://book.cakephp.org/phinx/0/en/migrations.html#the-change-method
     *
     * Remember to call "create()" or "update()" and NOT "save()" when working
     * with the Table class.
     */
    public function change(): void
    {
        $this->table('user_meta')
            ->addColumn('user', AdapterInterface::PHINX_TYPE_INTEGER, [
                'null' => false,
                'signed' => false,
            ])
            ->addColumn('meta_key', AdapterInterface::PHINX_TYPE_STRING, [
                'null' => false,
            ])
            ->addColumn('meta_value', AdapterInterface::PHINX_TYPE_TEXT, [
                'null' => false,
            ])
            ->addColumn('created', AdapterInterface::PHINX_TYPE_INTEGER, [
                'signed' => false,
            ])
            ->addColumn('created_by', AdapterInterface::PHINX_TYPE_INTEGER, [
                'signed' => false,
            ])
            ->addColumn('modified', AdapterInterface::PHINX_TYPE_INTEGER, [
                'signed' => false,
            ])
            ->addColumn('modified_by', AdapterInterface::PHINX_TYPE_INTEGER, [
                'signed' => false,
            ])
            ->addIndex(['user', 'meta_key'], [
                Index::UNIQUE => true,
            ])
            ->addIndex(['created'])
            ->addIndex(['user'])
            ->addIndex(['meta_key'])
            ->addForeignKey(['user'], 'users', 'id', [
                'delete' => ForeignKey::CASCADE,
                'update' => ForeignKey::CASCADE,
            ])
            ->create();
    }
}
