<?php


use Phinx\Seed\AbstractSeed;

class UserSeeder extends AbstractSeed
{
    /**
     * Run Method.
     *
     * Write your database seeder using this method.
     *
     * More information on writing seeders is available here:
     * https://book.cakephp.org/phinx/0/en/seeding.html
     */
    public function run(): void
    {
        $data = [
            [
                'id' => 0,
                'first_name' => 'Anonymous',
                'last_name' => 'user',
                'active' => 1,
                'email' => 'noemail@anon',
                'password' => 'ThisIsNotAPassword',
                'last_login' => null,
                'salt' => 'ThisIsNotASalt',
                'created' => 1688338523,
                'created_by' => 0,
                'modified' => null,
                'modified_by' => null,
            ],
            [
                'id' => 1,
                'first_name' => 'admin',
                'last_name' => 'user',
                'active' => 1,
                'email' => 'admin@apexlstudios.com',
                'password' => '$2y$07$hE/gbyxWn5saVzbRCUC.SOckDPZyNLvYuWTV2uANE3iXX90wZN8RS',
                'last_login' => 1722867021,
                'salt' => '$2y$07$hE/gbyxWn5saVzbRCUC.SaY8UT90x5NoVWGamDKE.fpaV2JxqCFpGBdtGr1HqajSr19ip4NJm1FkywB55HtUAQ==',
                'created' => 1676546921,
                'created_by' => 1,
                'modified' => 1722867021,
                'modified_by' => 1,
            ],
        ];

        $this->table('users')
            ->insert($data)
            ->saveData();

        $this->execute('update users set id=0 where email = \'noemail@anon\'');
    }
}
