<?php

namespace apexl\Io\modules\userDisplay\forms;

use apexl\Io\includes\Routes;
use apexl\Io\includes\System;
use apexl\Io\modules\display\components\form\CheckboxField;
use apexl\Io\modules\display\components\form\Form;
use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\inputField;
use apexl\Io\modules\user\entities\roleEntity;
use apexl\Io\modules\display\components\form\EntityForm;
use apexl\Io\modules\user\services\Permissions;
use Psr\Http\Message\ServerRequestInterface;

class rolesForm
{
    public static function rolesForm($args, Permissions $permissions): Form
    {
        $roleEntity = new roleEntity();
        $form = new EntityForm($roleEntity, $args, ['permissions']);
            //->deleteField("permissions");
        $form->setSubmitText('Submit');

        $permissions = $permissions->getPermissions();

        if (isset($args[$roleEntity->primaryKey])) {
            $roleEntity->load($args[$roleEntity->primaryKey]);
        }

        foreach ($permissions as $macName => $data) {
            $form->setFieldsetSetting($data->group, 'fieldset_legend', $data->group);

            $permissionBox = (new CheckboxField($macName))->setLabel($data->name);
            if (isset($args[$roleEntity->primaryKey])) {
                if ($roleEntity->hasPermission(constant($macName))) {
                    $permissionBox->setValue(true);
                } else {
                    $permissionBox->setValue(false);
                }
            }
            $form->addField($permissionBox, $data->group);
        }

        return $form;
    }
}
