<?php

namespace apexl\Io\modules\userDisplay\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\Routes;
use apexl\Io\includes\System;
use apexl\Io\modules\display\components\BasicLink;
use apexl\Io\modules\display\components\CardEntityFilteredDisplayTable;
use apexl\Io\modules\display\components\EntityDisplayTable;
use apexl\Io\modules\display\components\FormComponent;
use apexl\Io\modules\display\components\genericComponents;
use apexl\Io\modules\display\components\SimpleButton;
use apexl\Io\modules\display\includes\Forms;
use apexl\Io\modules\display\services\Render;
use apexl\Io\modules\formbuilder\includes\checkboxField;
use apexl\Io\modules\user\entities\roleEntity;
use apexl\Io\modules\user\enums\permissions\Role;
use apexl\Io\modules\user\services\currentUser;
use apexl\Io\modules\user\services\Permissions;
use apexl\Io\modules\userDisplay\callbacks\tableRowAlters;
use apexl\Io\modules\userDisplay\components\dashboardTiles;
use apexl\Io\modules\userDisplay\forms\rolesForm;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class rolesController extends Controller
{
    protected $permissions;
    protected $render;

    public function __construct(Render $render, Permissions $permissions)
    {
        parent::__construct();
        $this->permissions = $permissions;
        $this->render = $render;
    }


    /**
     * View the roleDisplay.
     * @return Response
     */
    public function view(Request $request, Response $response, $args)
    {
        $rowWrapper = genericComponents::rowWrapper('manageForm-wrapper col-sm-12');
        $rowWrapper->addComponent(dashboardTiles::roleViewTile($args['id']));

        $this->output::addResponse($request, $this->render::build([$rowWrapper]));
        return System::asJson($response);
    }

    /**
     * List roles.
     * @param $args
     * @return Response
     */
    public function roleList(Request $request, Response $response)
    {
        $this->render::setPageTitle('Roles List');

        $components = [];

        $currentUser = currentUser::getCurrentUser();
        if ($currentUser && ($currentUser->isAllowed(Role::CREATE))) {
            $createButton = (new BasicLink())
                ->addText('Create Role')
                ->addRoute(Routes::getRoutePattern('roleEntity.display.post'))
                ->addClass('btn btn-primary');
            $components[] = $createButton;
        }

        $components[] = (new CardEntityFilteredDisplayTable(new roleEntity(), [], false, 'dropmenu'))
            ->displayPagination(FALSE)
            ->displayShortTotals(FALSE)
            ->hideIdColumn()
            ->addDropMenuItem('roleEntity.display.put', 'Edit')
            ->addTitle('Roles List')
        ;

        $this->output::addResponse($request, $this->render::build($components));
        return System::asJson($response);
    }

    public function create(Request $request, Response $response, $args)
    {
        $title = 'Create new role';
        if ($id = $args['id'] ?? false) {
            $role = new roleEntity();
            $role->load($id);
            $title = 'Update ' . $role->name;
        }
        $form = rolesForm::rolesForm($args, $this->permissions);
        $this->render::setPageTitle($title);
        $this->output::addResponse($request, $this->render::build([genericComponents::dashboardBlockWrapper([$form])]));
        return System::asJson($response);
    }


    /**
     * @param array $args
     * @return Response
     */
    public function updateView(Request $request, Response $response, $args = [])
    {
        $form = rolesForm::rolesForm($args, $this->permissions);
        $this->render::setPageTitle((isset($args['id']) ? 'Update' : 'Create').' Role');
        $this->output::addResponse($request, $this->render::build($form));
        return System::asJson($response);
    }

    public function roleSummery(Request $request, Response $response, $args)
    {
        $structure = [
            'tableHeader' => [
                'Role ID',
                'Role Name',
                'Role Created',
                'Role Created By',
                'permissions',
            ],
            'fields' => [
                'id',
                'name',
                'created',
                'created_by',
                'permissions',
            ],
            'callables' => [
                'field__created' => function ($key, $entityId, $row) {
                    return \apexl\Io\modules\userDisplay\callbacks\tableRowAlters::roleShortTable($key, $entityId, $row);
                },
                'field__created_by' => function ($key, $entityId, $row) {
                    return \apexl\Io\modules\userDisplay\callbacks\tableRowAlters::roleShortTable($key, $entityId, $row);
                },
                'field__permissions' => function ($key, $entityId, $row) {
                    return \apexl\Io\modules\userDisplay\callbacks\tableRowAlters::roleShortTable($key, $entityId, $row);
                }
            ]
        ];
        return $this->getEntityData($request, $response, $args, (new roleEntity()), [], $structure);
    }
}
