<?php
declare(strict_types=1);

use Phinx\Db\Adapter\AdapterInterface;
use Phinx\Db\Table\Index;
use Phinx\Migration\AbstractMigration;

final class CreateUsers extends AbstractMigration
{
    /**
     * Change Method.
     *
     * Write your reversible migrations using this method.
     *
     * More information on writing migrations is available here:
     * https://book.cakephp.org/phinx/0/en/migrations.html#the-change-method
     *
     * Remember to call "create()" or "update()" and NOT "save()" when working
     * with the Table class.
     */
    public function change(): void
    {
        $this->table('users')
            ->addColumn('first_name', AdapterInterface::PHINX_TYPE_STRING, ['limit' => 255, 'null' => false])
            ->addColumn('last_name', AdapterInterface::PHINX_TYPE_STRING, ['limit' => 255, 'null' => false])
            ->addColumn('active', AdapterInterface::PHINX_TYPE_BOOLEAN, ['default' => true, 'null' => false])
            ->addColumn('email', AdapterInterface::PHINX_TYPE_STRING, ['limit' => 255, 'null' => false])
            ->addColumn('password', AdapterInterface::PHINX_TYPE_STRING, ['limit' => 255, 'null' => false])
            ->addColumn('last_login', AdapterInterface::PHINX_TYPE_INTEGER, ['null' => true])
            ->addColumn('salt', AdapterInterface::PHINX_TYPE_STRING, ['limit' => 128, 'null' => false])
            ->addColumn('roles', AdapterInterface::PHINX_TYPE_TEXT, ['null' => true])
            ->addColumn('created', AdapterInterface::PHINX_TYPE_INTEGER, ['null' => true])
            ->addColumn('created_by', AdapterInterface::PHINX_TYPE_INTEGER, ['null' => true])
            ->addColumn('modified', AdapterInterface::PHINX_TYPE_INTEGER, ['null' => true])
            ->addColumn('modified_by', AdapterInterface::PHINX_TYPE_INTEGER, ['null' => true])
            ->addIndex(['created'])
            ->addIndex(['created_by'])
            ->addIndex(['modified'])
            ->addIndex(['modified_by'])
            ->addIndex(['last_name'])
            ->addIndex(['email'], [Index::UNIQUE => true])
            ->create();
    }
}
