<?php

namespace apexl\Io\modules\userDisplay\forms;

use apexl\Io\includes\Routes;
use apexl\Io\includes\System;
use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\inputField;
use Psr\Http\Message\ServerRequestInterface;

class loginForm
{
    public function loginForm(?ServerRequestInterface $request = null): array
    {
        $form = new formEntity();
        $form->setMethod('post');
        $form->setActionUrl(Routes::getRoutePattern('user.login'));
        $form->setSubmitText(System::getVariable('user_login_submit_text') ?? 'Sign in');
        if (System::getVariable('user_login_include_clear_button') ?? true) {
            $form->includeClearButton()->setClearButtonText(
                System::getVariable('user_login_include_clear_button_text') ?? 'Cancel'
            );
        }

        if ($request) {
            $redirect = ($request->getQueryParams()['redirect'] ?? null);
            if ($redirect) {
                $form->addField(
                    (new inputField('redirect'))
                        ->setInputType('hidden')
                        ->setValue($redirect)
                );
            }
        }

        $form->addField(
            (new inputField('username'))->setPlaceholder(
                System::getVariable('user_login_email_placeholder') ?? 'Enter your email address'
            )->setLabel('Email')->setInputType('email')->isRequired()
        );
        $form->addField(
            (new inputField('password'))->setPlaceholder(
                System::getVariable('user_login_password_placeholder') ?? 'Enter your password'
            )->setLabel('Password')->setInputType('password')->isRequired()
        );

        return $form->getBuiltFormArray();
    }
}
