<?php

namespace apexl\Io\modules\user\classes;

use apexl\Io\enums\HttpMethod;
use apexl\Io\includes\Controller;
use apexl\Io\includes\Entity;
use apexl\Io\recommendedIncludes\apiModule;
use apexl\Io\modules\user\enums\permissions\Common;

use apexl\Io\modules\user\interfaces\PermissionInterface;

class userManagedApiModule extends apiModule
{
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Method to add a route, allows the module to have a base path configured and for easy overrides.
     * This Method adds one extra option over the base, to permissions protect a route.
     */
    protected function addProtectedActionRoute(
        HttpMethod $verb,
        string $name,
        string $pattern,
        $callable,
        PermissionInterface $permission = Common::ALLOW_ALL,
    ): static {
        $this->addActionRoute($verb, $name, $pattern, $callable);
        $this->route::addRouteArg($name, 'permission', serialize($permission));

        return $this;
    }

    protected function addProtectedAdminActionRoute(
        HttpMethod $verb,
        string $name,
        string $pattern,
        $callable,
        PermissionInterface $permission = Common::ALLOW_ALL,
    ): static {
        $this->addActionRoute($verb, $name, 'admin/'.$pattern, $callable);
        $this->route::addRouteArg($name, 'permission', serialize($permission));

        return $this;
    }

    /**
     * Method to add a route, allows the module to have a base path configured and for easy overrides.
     * This Method adds one extra option over the base, to permissions protect a route.
     */
    protected function addProtectedDataRoute(
        HttpMethod $verb,
        string $name,
        string $pattern,
        $callable,
        PermissionInterface $permission = Common::ALLOW_ALL,
    ): static {
        $this->addDataRoute($verb, $name, $pattern, $callable);
        $this->route::addRouteArg($name, 'permission', serialize($permission));

        return $this;
    }

    /**
     * Declare intention to build routes for this entity. Will take defaults if not previously defined.
     */
    protected function addProtectedEntityRoutes(Entity $entity, $callables = null, array $patterns = []): static
    {
        $this->setEntityPatterns($entity, $patterns);

        foreach ($this->entityPatterns[$entity->getEntityName()] as $verb => $pattern) {
            $this->setEntityCallable($entity, $verb, ($callables[$verb][0] ?? Controller::class.':'.$verb));
        }

        //build the routes.
        $this->buildEntityRoutes($entity);
        //protect the built routes
        foreach ($this->entityPatterns[$entity->getEntityName()] as $verb => $pattern) {
            $this->route::addRouteArg(
                $entity->getEntityName().'.'.strtolower((string) $verb),
                'permission',
                serialize($callables[$verb][1] ?? Common::ALLOW_ALL)
            );
            $this->route::addRouteArg(
                $entity->getEntityName().'.'.strtolower((string) $verb),
                'entity',
                $entity::class
            );
        }

        return $this;
    }
}
