<?php
declare(strict_types=1);

use Phinx\Db\Adapter\AdapterInterface;
use Phinx\Db\Table\ForeignKey;
use Phinx\Db\Table\Index;
use Phinx\Migration\AbstractMigration;

final class CreatePermissionsRoles extends AbstractMigration
{
    /**
     * Change Method.
     *
     * Write your reversible migrations using this method.
     *
     * More information on writing migrations is available here:
     * https://book.cakephp.org/phinx/0/en/migrations.html#the-change-method
     *
     * Remember to call "create()" or "update()" and NOT "save()" when working
     * with the Table class.
     */
    public function change(): void
    {
        $this->table('permissions__roles')
            ->addColumn('permission', AdapterInterface::PHINX_TYPE_STRING, [
                'null' => false,
            ])
            ->addColumn('role', AdapterInterface::PHINX_TYPE_INTEGER, [
                'null' => false,
                'signed' => false,
            ])
            ->addIndex(['role', 'permission'], [
                Index::UNIQUE => true,
            ])
            ->addForeignKey('role', 'roles', 'id', [
                'delete' => ForeignKey::CASCADE,
                'update' => ForeignKey::CASCADE,
            ])
            ->create();

    }
}
