<?php
declare(strict_types=1);

use Phinx\Db\Adapter\AdapterInterface;
use Phinx\Migration\AbstractMigration;

final class CreateRefreshTokens extends AbstractMigration
{
    /**
     * Change Method.
     *
     * Write your reversible migrations using this method.
     *
     * More information on writing migrations is available here:
     * https://book.cakephp.org/phinx/0/en/migrations.html#the-change-method
     *
     * Remember to call "create()" or "update()" and NOT "save()" when working
     * with the Table class.
     */
    public function change(): void
    {
        $this->table('refresh_tokens', ['id' => false, 'primary_key' => ['user_id']])
            ->addColumn('user_id', AdapterInterface::PHINX_TYPE_INTEGER, ['null' => false])
            ->addColumn('token', AdapterInterface::PHINX_TYPE_STRING, ['limit' => 255, 'null' => false])
            ->addColumn('expiry', AdapterInterface::PHINX_TYPE_INTEGER, ['null' => false])
            ->addIndex(['user_id'])
            ->addIndex(['token'])
            ->create();
    }
}
