<?php

/** @noinspection PhpUnused */

namespace apexl\Io\modules\userDisplay;

use apexl\Io\enums\HttpMethod;
use apexl\Io\modules\display\controllers\displayController;
use apexl\Io\modules\menu\interfaces\registersMenuItems;
use apexl\Io\modules\menu\services\Menu;
use apexl\Io\modules\user\classes\userManagedDisplayModule;
use apexl\Io\modules\user\entities\roleEntity;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\enums\permissions\Role;
use apexl\Io\modules\user\enums\permissions\User;
use apexl\Io\modules\userDisplay\controllers\rolesController;
use apexl\Io\modules\userDisplay\controllers\userController;
use apexl\Io\modules\userDisplay\forms\filters;
use apexl\Io\modules\userDisplay\hooks\RegisterRedirects;
use app\module\newtonsTrailers\Enum\Permission\Common;
use app\vendor\apexl\io\src\Io\interfaces\HasHooksInterface;

class userDisplayModule extends userManagedDisplayModule implements HasHooksInterface, RegistersMenuItems
{
    public function __construct()
    {
        parent::__construct();
    }

    public function routes(): void
    {
        //Page routes.
        $this->addProtectedRootRoute(
            HttpMethod::GET,
            'user.display.login',
            'login[/{loginMessageType}]',
            userController::class.':loginPage'
        );
        $this->addProtectedRootRoute(
            HttpMethod::GET,
            'user.display.register',
            'register',
            userController::class.':registerPage'
        );
        $this->addProtectedRootRoute(
            HttpMethod::GET,
            'user.display.forgot-password',
            'forgot-password',
            userController::class.':forgotPasswordPage'
        );
        $this->addProtectedRootRoute(
            HttpMethod::GET,
            'user.display.forgot-password.check-email',
            'forgot-password/check-email',
            userController::class.':forgotPasswordCheckEmail'
        );
        $this->addProtectedRootRoute(
            HttpMethod::GET,
            'user.display.settings',
            'user/settings',
            userController::class.':userSettingsPage',
            Common::IS_LOGGED_IN
        );
        $this->addProtectedRootRoute(
            HttpMethod::GET,
            'user.display.dashboard',
            'users',
            userController::class.':userHome',
            Common::IS_LOGGED_IN
        );
        $this->addProtectedRootRoute(
            HttpMethod::GET,
            'user.display.user-notes',
            'user-notes/{id}',
            userNoteController::class.':userNotes',
            User::UPDATE,
        );
        //$this->route->get('/users', userController::class.':userHome', 'ViewUsers')->addToMenu("User Dashboard", "", '/usersParent');

        //These are display routes, so in this instance VERBS are used to dictate the pattern, NOT the HTTP verb.
        $this->addProtectedEntityRoutes(
            (new userEntity()),
            [
                'all' => [userController::class.':userList', User::VIEW],
                'get' => [userController::class.':userViewSingle', User::VIEW],
                'put' => [userController::class.':updateView', User::UPDATE],
                'post' => [userController::class.':create', User::CREATE],
                'delete' => [displayController::class.':delete', User::DELETE],
            ]
        );

        $this->addProtectedEntityRoutes(
            (new roleEntity()),
            [
                'all' => [rolesController::class.':roleList', Role::VIEW],
                'get' => [rolesController::class.':view', Role::VIEW],
                'put' => [rolesController::class.':updateView', Role::UPDATE],
                'post' => [rolesController::class.':create', Role::CREATE],
                'delete' => [displayController::class.':delete', Role::DELETE],
            ]
        );

        //data routes
        $this->addProtectedDataRoute(
            HttpMethod::GET,
            'userEntity.data.summery',
            'user-summery',
            userController::class.':userSummery',
            User::VIEW
        );
        $this->addProtectedDataRoute(
            HttpMethod::GET,
            'roleEntity.data.summery',
            'role-summery',
            rolesController::class.':roleSummery',
            Role::VIEW
        );

        //Forms - Users
        $this->addProtectedFormRoute(
            'user.display.forms.login',
            'loginForm[/{redirectToRoute}]',
            userController::class.':loginForm'
        );
        $this->addProtectedFormRoute(
            'user.display.forms.forgottenPassword',
            'forgottenPasswordForm',
            userController::class.':forgotPasswordForm'
        );
        $this->addProtectedFormRoute(
            'user.display.forms.register',
            'registerForm',
            userController::class.':registerForm'
        );
        $this->addProtectedFormRoute(
            'user.display.forms.userSettings',
            'userSettings',
            userController::class.':userSettingsForm',
            Common::IS_LOGGED_IN
        );
        $this->addProtectedFormRoute(
            'user.display.forms.createUpdate',
            'userCreate[/{id}]',
            userController::class.':userEditForm',
            User::CREATE
        );
        $this->addProtectedFormRoute(
            'user.display.forms.loginAsUser',
            'loginAsUserForm/{userId}',
            userController::class.':loginAsUserForm',
            User::MANAGE
        );
        $this->addProtectedFormRoute(
            'user.display.forms.createNote',
            'create-user-note/{userId}',
            userNoteController::class.':createNoteForm',
            User::UPDATE
        );

        //Forms - Roles
        $this->addProtectedFormRoute(
            'role.display.forms.createUpdate',
            'roleCreate[/{id}]',
            rolesController::class.':manageForm',
            Role::CREATE
        );

        //Filter forms
        $this->addProtectedFormRoute(
            'user.display.forms.filters.userFilter',
            'user-filter',
            filters::class.':userFilter',
            User::VIEW
        );
    }

    public function menuItems(Menu $menu): void
    {
        // Navigation Menu
        $menu::addToMenu('home', [
            'title' => 'Home',
            'icon' => 'home',
            'weight' => -10,
        ]);

        //Administration menu
        $menu::addToMenu('user.admin', [
            'title' => 'Users',
            'icon' => 'users',
            'weight' => 0,
        ], 'administration');

        $menu::addToMenu('user.display.dashboard', [
            'title' => 'Overview',
            'weight' => -10,
            'parent' => 'user.admin',
            'icon' => 'user-chart',
        ], 'administration');

        $menu::addToMenu('userEntity.display.all', [
            'title' => 'View all users',
            'weight' => -9,
            'parent' => 'user.admin',
            'icon' => 'users',
        ], 'administration');

        $menu::addToMenu('userEntity.display.post', [
            'title' => 'Create a user',
            'weight' => -8,
            'parent' => 'user.admin',
            'icon' => 'users-medical',
        ], 'administration');

        $menu::addToMenu('roleEntity.display.all', [
            'title' => 'View all roles',
            'weight' => -9,
            'parent' => 'user.admin',
            'icon' => 'user-secret',
        ], 'administration');

        $menu::addToMenu('roleEntity.display.post', [
            'title' => 'Create a role',
            'weight' => -8,
            'parent' => 'user.admin',
            'icon' => 'user-unlock',
        ], 'administration');
    }

    public function hooks(): array
    {
        return [
            RegisterRedirects::class,
        ];
    }
}
