<?php

declare(strict_types=1);

namespace apexl\Io\modules\user\hooks;

use apexl\Io\hooks\AbstractHook;
use apexl\Io\includes\Module;
use apexl\Io\modules\notifier\exceptions\notifierException;
use apexl\Io\modules\user\interfaces\registersPermissions;
use apexl\Io\modules\user\services\Permissions;
use Exception;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

final readonly class RegisterModulePermissions extends AbstractHook
{

    public function __construct(private Permissions $permissions)
    {
    }

    static protected function hooks(): array
    {
        return ['initialiseModule'];
    }

    /**
     * @throws ContainerExceptionInterface
     * @throws NotFoundExceptionInterface
     * @throws notifierException
     * @throws Exception
     */
    public function __invoke(Module $module): Module
    {
        if (method_exists($module, 'registerPermissions')) {
            logger('error')->warning(
                sprintf(
                    'Deprecation - Module \'%s\' should register permissions by implementing %s\n',
                    $module->getName(),
                    registersPermissions::class,
                ),
            );
            $module->registerPermissions($this->permissions);

            return $module;
        }

        if ($module instanceof registersPermissions) {
            $module->permissions($this->permissions);
        }

        return $module;
    }
}
