<?php

declare(strict_types=1);

namespace apexl\Io\modules\user\enums\permissions;

use apexl\Io\modules\user\traits\IsPermissionTrait;
use apexl\Io\modules\user\interfaces\PermissionInterface;

enum User implements PermissionInterface, \JsonSerializable
{
    use IsPermissionTrait;

    case MANAGE;
    case CREATE;
    case VIEW;
    case UPDATE;
    case DELETE;

    case CHANGE_ACTIVE_STATE;
    case CAN_REGISTER;
    case UPDATE_SELF;

}
