<?php

declare(strict_types=1);

namespace apexl\Io\modules\user\Actions;

use apexl\Io\exceptions\RecordNotFoundException;
use apexl\Io\modules\user\entities\RefreshToken;
use apexl\Io\modules\user\exceptions\RefreshTokenExpiredException;
use apexl\Io\modules\user\services\JwtCreator;

final readonly class RefreshAction
{
    public function __construct(
        private JwtCreator $jwtCreator,
    ) {}

    /**
     * @throws RefreshTokenExpiredException
     * @throws RecordNotFoundException
     */
    public function handle(string $token, string $sessionId): string
    {
        $refreshTokenEntity = RefreshToken::fromToken($token);

        if ($refreshTokenEntity->isExpired()) {
            throw new RefreshTokenExpiredException('Token expired');
        }

        // Refresh token still valid?
        $user = $refreshTokenEntity->user();

        $authToken = $this->jwtCreator->forUser(
            $user,
            $sessionId,
        );
        $refreshTokenEntity->expiry = RefreshToken::newExpiryFrom();
        $refreshTokenEntity->store();

        return $authToken;
    }
}