<?php

declare(strict_types=1);

namespace apexl\Io\modules\user\Request;

use apexl\Io\exceptions\ValidationException;
use apexl\Io\Request\IoRequest;

final class LoginRequest extends IoRequest
{
    /**
     * @throws ValidationException
     */
    public function validate(): void
    {
//        $this->requireBody('username', 'Please provide a username');
//        $this->requireBody('password', 'Please provide an password address');
    }

    public function username(): string
    {
        return $this->bodyParam('username', '');
    }

    public function password(): string
    {
        return $this->bodyParam('password', '');
    }

    public function redirect(): ?string
    {
        return $this->bodyParam('redirect') ?: '/';
    }
}
