<?php

declare(strict_types=1);

namespace apexl\Io\modules\user\Request;

use apexl\Io\modules\validation\Exceptions\ValidationException;
use apexl\Io\Request\IoRequest;

final class ForgotPasswordRequest extends IoRequest
{
    /**
     * @throws ValidationException
     */
    public function validate(): void
    {
//        $this->requireBody('email', 'Please provide an email address');

        if (!filter_var($this->email(), FILTER_VALIDATE_EMAIL)) {
            throw new ValidationException('Please provide valid email address');
        }
    }

    public function email(): string
    {
        return $this->bodyParam('email');
    }
}
