<?php

declare(strict_types=1);

namespace apexl\Io\modules\user\Request;

use apexl\Io\modules\userDisplay\FormBuilders\LoginFormBuilder;
use apexl\Io\modules\validation\Services\ValidationRuleCollector;
use apexl\Io\modules\validation\Services\Validator;
use apexl\Io\Request\IoRequest;
use Psr\Http\Message\StreamInterface;
use Psr\Http\Message\UriInterface;
use Slim\Psr7\Interfaces\HeadersInterface;

final class LoginRequest extends IoRequest
{
    public function __construct(
        $method,
        UriInterface $uri,
        HeadersInterface $headers,
        array $cookies,
        array $serverParams,
        StreamInterface $body,
        array $uploadedFiles,
        private Validator $validator,
        private ValidationRuleCollector $validationRuleCollector,
        private LoginFormBuilder $formBuilder,
    ) {
        parent::__construct(
            $method,
            $uri,
            $headers,
            $cookies,
            $serverParams,
            $body,
            $uploadedFiles,
        );
    }

    public function validate(): void
    {
        $this->validator->validate(
            $this->getParsedBody(),
            $this->validationRuleCollector->collect($this->formBuilder)
        );
//        $this->requireBody('username', 'Please provide a username');
//        $this->requireBody('password', 'Please provide an password address');
    }

    public function username(): string
    {
        return $this->bodyParam('username', '');
    }

    public function password(): string
    {
        return $this->bodyParam('password', '');
    }

    public function redirect(): ?string
    {
        return $this->bodyParam('redirect') ?: '/';
    }
}
