<?php

namespace apexl\Io\modules\user\controllers;

use apexl\Io\exceptions\RecordNotFoundException;
use apexl\Io\includes\Controller;
use apexl\Io\includes\RouteManager;
use apexl\Io\modules\notifier\exceptions\notifierException;
use apexl\Io\modules\user\Actions\ForgotPasswordAction;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\Request\ForgotPasswordRequest;
use apexl\Io\modules\user\RequestHelper\ForgotPasswordRequestHelper;
use JsonException;
use Psr\Http\Message\ResponseInterface;

final readonly class ForgotPasswordController extends Controller
{
    /**
     * @throws notifierException
     * @throws JsonException
     */
    public function __invoke(
        ForgotPasswordRequest $request,
        ResponseInterface $response,
        ForgotPasswordAction $forgotPasswordAction,
        RouteManager $routeManager,
    ): ResponseInterface {
        try {
            $user = userEntity::from('email', $request->email());

            $forgotPasswordAction->handle($user);

            $this->output->addMetadata(
                'user.forgot-password.redirect',
                'redirect',
                $routeManager->getRoutePattern('user.display.forgot-password.check-email')
            );
        } catch (RecordNotFoundException) {
            $this->output->addMessage('user.forgot-password', 'error', 'User account does not exist');
        }

        return $this->json($response);
    }
}
